(ns com.adgoji.displayvideo-api.advertisers
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.advertisers.interface :as advertisers]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn get-list
  "Returns a list of available advertisers by `partner-id`."
  [client partner-id opts]
  (advertisers/get-list client partner-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/advertisers)

(defn get-by-id
  "Returns a single advertiser by `advertiser-id`."
  [client advertiser-id]
  (advertisers/get-by-id client advertiser-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id)
  :ret ::displayvideo-spec/advertiser)

(defn create
  "Create a new advertiser."
  [client advertiser]
  (advertisers/create client advertiser))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser ::displayvideo-spec/advertiser)
  :ret ::displayvideo-spec/advertiser)

(defn delete
  "Delete an advertives by `advertiser-id`."
  [client advertiser-id]
  (advertisers/delete client advertiser-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id)
  :ret (s/and map? empty?))

(defn update-by-id
  "Update an existing advertiser by `advertiser-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords).

  Example:
  ```
  [:display-name general-config.domain-url]
  ```."
  [client advertiser-id advertiser update-mask]
  (advertisers/update-by-id client advertiser-id advertiser update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :advertiser ::displayvideo-spec/advertiser-update
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/advertiser)
