(ns com.adgoji.targeting-types-targeting-options.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v4 DisplayVideo DisplayVideo$TargetingTypes$TargetingOptions DisplayVideo$TargetingTypes$TargetingOptions$List)
   (com.google.api.services.displayvideo.v4.model SearchTargetingOptionsRequest)))

(defn- fetch-targeting-options-page
  [^DisplayVideo$TargetingTypes$TargetingOptions$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn- fetch-targeting-options-search-page
  [^DisplayVideo$TargetingTypes$TargetingOptions request
   ^String targeting-type
   search-targeting-option-conformed
   ^String next-page-token]
  (let [search-targeting-option-request
        (java-utils/clj->java SearchTargetingOptionsRequest
                              (assoc search-targeting-option-conformed
                                     :page-token next-page-token))]
    (-> request
        (.search targeting-type search-targeting-option-request)
        (sdk-client-utils/execute-and-convert))))

(defn get-by-id
  [^DisplayVideo client targeting-type targeting-option-id advertiser-id]
  (-> client
      (.targetingTypes)
      (.targetingOptions)
      (.get targeting-type targeting-option-id)
      (.setAdvertiserId (long advertiser-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/targeting-option)))

(defn get-list
  [^DisplayVideo client
   targeting-type
   advertiser-id
   {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.targetingTypes)
                    (.targetingOptions)
                    (.list targeting-type)
                    (.setAdvertiserId (long advertiser-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$TargetingTypes$TargetingOptions$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$TargetingTypes$TargetingOptions$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated (partial fetch-targeting-options-page request)
                                                        :targeting-options
                                                        limit)
        (spec/check ::displayvideo-spec/targeting-options))))

(defn search
  [^DisplayVideo client targeting-type search-targeting-option {:keys [limit]}]
  (let [search-targeting-option-conformed
        (spec/check search-targeting-option
                    ::displayvideo-spec/search-targeting-option-request)

        request (-> client
                    (.targetingTypes)
                    (.targetingOptions))]
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-targeting-options-search-page
                  request
                  targeting-type
                  search-targeting-option-conformed)
         :targeting-options
         limit)
        (spec/check ::displayvideo-spec/targeting-options))))
