(ns com.adgoji.advertisers-channels.interface
  (:require
   [com.adgoji.advertisers-channels.core :as channels.core]))

(defn get-by-id
  [client advertiser-id channel-id]
  (channels.core/get-by-id client advertiser-id channel-id))

(defn create
  [client advertiser-id channel]
  (channels.core/create client advertiser-id channel))

(defn update-by-id
  [client advertiser-id channel-id channel update-mask]
  (channels.core/update-by-id client
                              advertiser-id
                              channel-id
                              channel
                              update-mask))

(defn get-list
  [client advertiser-id opts]
  (channels.core/get-list client advertiser-id opts))