(ns com.adgoji.advertisers-assigned-locations.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v3 DisplayVideo DisplayVideo$Advertisers$LocationLists$AssignedLocations$List)
   (com.google.api.services.displayvideo.v3.model AssignedLocation BulkEditAssignedLocationsRequest)))

(defn bulk-edit
  [^DisplayVideo client
   advertiser-id
   location-list-id
   bulk-edit]
  (let [bulk-edit-locations-conformed
        (spec/check bulk-edit ::displayvideo-spec/bulk-edit-assigned-locations-request)

        bulk-edit-locations-request
        (java-utils/clj->java BulkEditAssignedLocationsRequest bulk-edit-locations-conformed)]
    (-> client
        (.advertisers)
        (.locationLists)
        (.assignedLocations)
        (.bulkEdit (long advertiser-id) (long location-list-id) bulk-edit-locations-request)
        (sdk-client-utils/execute-and-convert)
        (:assigned-locations)
        (spec/check ::displayvideo-spec/assigned-locations))))

(defn create
  [^DisplayVideo client advertiser-id location-list-id assigned-location]
  (let [location-list-conformed
        (spec/check assigned-location ::displayvideo-spec/assigned-location)

        assigned-location-request
        (java-utils/clj->java AssignedLocation location-list-conformed)]
    (-> client
        (.advertisers)
        (.locationLists)
        (.assignedLocations)
        (.create (long advertiser-id) (long location-list-id) assigned-location-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/assigned-location))))

(defn- fetch-location-lists-page
  [^DisplayVideo$Advertisers$LocationLists$AssignedLocations$List
   request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client advertiser-id location-list-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.locationLists)
                    (.assignedLocations)
                    (.list (long advertiser-id) (long location-list-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$LocationLists$AssignedLocations$List
       request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$LocationLists$AssignedLocations$List
       request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated (partial fetch-location-lists-page request)
                                                        :assigned-locations
                                                        limit)
        (spec/check ::displayvideo-spec/assigned-locations))))

(defn delete
  [^DisplayVideo client advertiser-id location-list-id assigned-location-id]
  (-> client
      (.advertisers)
      (.locationLists)
      (.assignedLocations)
      (.delete (long advertiser-id) (long location-list-id) (long assigned-location-id))
      (sdk-client-utils/execute-and-convert)))
