(ns com.adgoji.displayvideo-spec.displayvideo.channel
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.partner :as partner]))

(s/def ::name string?)
(s/def ::channel-id int?)
(s/def ::display-name string?)
(s/def ::positively-targeted-line-item-count int?)
(s/def ::negatively-targeted-line-item-count int?)

(s/def ::spec
  (spec/only-keys :req-un [::display-name]
                  :opt-un [::name
                           ::channel-id
                           ::positively-targeted-line-item-count
                           ::negatively-targeted-line-item-count
                           ::advertiser/advertiser-id
                           ::partner/partner-id]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::display-name
                           ::name
                           ::channel-id
                           ::positively-targeted-line-item-count
                           ::negatively-targeted-line-item-count
                           ::advertiser/advertiser-id
                           ::partner/partner-id]))
