(ns com.adgoji.displayvideo-spec.displayvideo.advertiser
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.ad-server-config
    :as advertiser.ad-server-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.billing-config
    :as advertiser.billing-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.creative-config
    :as advertiser.creative-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.data-access-config
    :as advertiser.data-access-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.general-config
    :as advertiser.general-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.targeting-config
    :as advertiser.targeting-config]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details
    :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.partner :as partner]))

(s/def ::name string?)
(s/def ::advertiser-id int?)
(s/def ::display-name string?)
(s/def ::entity-status
  #{"ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)
(s/def ::prisma-enabled boolean?)
(s/def ::general-config ::advertiser.general-config/spec)

(defmulti ad-server-config-spec keys)

(defmethod ad-server-config-spec '(:third-party-only-config)
  [_]
  (s/keys :req-un [::advertiser.ad-server-config/third-party-only-config]))

(defmethod ad-server-config-spec '(:cm-hybrid-config)
  [_]
  (s/keys :req-un [::advertiser.ad-server-config/cm-hybrid-config]))

(s/def ::ad-server-config
  (s/multi-spec ad-server-config-spec ::ad-server-config))

(s/def ::creative-config ::advertiser.creative-config/spec)
(s/def ::data-access-config ::advertiser.data-access-config/spec)
(s/def ::integration-details ::integration-details/spec)
(s/def ::serving-config ::advertiser.targeting-config/spec)
(s/def ::billing-config ::advertiser.billing-config/spec)

(s/def ::spec
  (s/keys :req-un [::partner/partner-id
                   ::display-name
                   ::entity-status
                   ::general-config
                   ::ad-server-config
                   ::creative-config]
          :opt-un [::name
                   ::advertiser-id
                   ::update-time
                   ::prisma-enabled
                   ::data-access-config
                   ::integration-details
                   ::serving-config
                   ::billing-config]))
