(ns com.adgoji.partner-channels.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v3 DisplayVideo DisplayVideo$Partners$Channels$List)
   (com.google.api.services.displayvideo.v3.model Channel)))

(defn- fetch-channels-page
  [^DisplayVideo$Partners$Channels$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn create
  [^DisplayVideo client partner-id channel]
  (let [channel-conformed (spec/check channel ::displayvideo/channel)
        channel-request   (java-utils/clj->java Channel channel-conformed)]
    (-> client
        (.partners)
        (.channels)
        (.create (long partner-id) channel-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo/channel))))

(defn get-by-id
  [^DisplayVideo client partner-id channel-id]
  (-> client
      (.partners)
      (.channels)
      (.get (long partner-id) (long channel-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo/channel)))

(defn update-by-id
  [^DisplayVideo client
   partner-id
   channel-id
   channel
   update-mask]
  (let [mask            (-> update-mask
                            (spec/check ::displayvideo/update-mask)
                            sdk-client-utils/normalize-mask)
        channel-request (java-utils/clj->java Channel channel)]
    (-> client
        (.partners)
        (.channels)
        (.patch (long partner-id) (long channel-id) channel-request)
        (.setUpdateMask mask)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo/channel))))

(defn get-list
  [^DisplayVideo client partner-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.partners)
                    (.channels)
                    (.list (long partner-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Partners$Channels$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Partners$Channels$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-channels-page request)
         :channels
         limit)
        (spec/check ::displayvideo/channels))))
