(ns com.adgoji.displayvideo-spec.displayvideo.insertion-order
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.bidding-strategy
    :as bidding-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap
    :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order.budget
    :as insertion-order.budget]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details
    :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.kpi :as kpi]
   [com.adgoji.displayvideo-spec.displayvideo.pacing :as pacing]
   [com.adgoji.displayvideo-spec.displayvideo.partner-costs
    :as partner-costs]
   [com.adgoji.spec.interface :as spec]))

(s/def ::name string?)
(s/def ::insertion-order-id pos-int?)
(s/def ::display-name string?)
(s/def ::insertion-order-type
  #{"INSERTION_ORDER_TYPE_UNSPECIFIED"
    "RTB"
    "OVER_THE_TOP"})
(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)
(s/def ::partner-costs (s/coll-of ::partner-costs/spec :into []))
(s/def ::pacing ::pacing/spec)
(s/def ::frequency-cap ::frequency-cap/spec)
(s/def ::integration-details ::integration-details/spec)
(s/def ::kpi ::kpi/spec)
(s/def ::budget ::insertion-order.budget/spec)
(s/def ::bid-strategy ::bidding-strategy/spec)
(s/def ::reservation-type
  #{"RESERVATION_TYPE_UNSPECIFIED"
    "RESERVATION_TYPE_NOT_GUARANTEED"
    "RESERVATION_TYPE_PROGRAMMATIC_GUARANTEED"
    "RESERVATION_TYPE_TAG_GUARANTEED"
    "RESERVATION_TYPE_PETRA_VIRAL"
    "RESERVATION_TYPE_INSTANT_RESERVE"})
(s/def ::optimization-objective
  #{"OPTIMIZATION_OBJECTIVE_UNSPECIFIED"
    "CONVERSION"
    "CLICK"
    "BRAND_AWARENESS"
    "CUSTOM"
    "NO_OBJECTIVE"})

(s/def ::spec
  (spec/only-keys :req-un [::display-name
                           ::campaign/campaign-id
                           ::entity-status
                           ::pacing
                           ::frequency-cap
                           ::kpi
                           ::budget]
                  :opt-un [::name
                           ::advertiser/advertiser-id
                           ::insertion-order-id
                           ::insertion-order-type
                           ::update-time
                           ::partner-costs
                           ::integration-details
                           ::bid-strategy
                           ::reservation-type
                           ::optimization-objective]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::display-name
                           ::campaign/campaign-id
                           ::entity-status
                           ::pacing
                           ::frequency-cap
                           ::kpi
                           ::budget
                           ::name
                           ::advertiser/advertiser-id
                           ::insertion-order-id
                           ::insertion-order-type
                           ::update-time
                           ::partner-costs
                           ::integration-details
                           ::bid-strategy
                           ::reservation-type
                           ::optimization-objective]))
