(ns com.adgoji.assets.core
  (:require
   [clojure.java.io :as io]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.client.http InputStreamContent)
   (com.google.api.services.displayvideo.v3 DisplayVideo)
   (com.google.api.services.displayvideo.v3.model CreateAssetRequest)
   (java.net URLConnection)))

(defn- mime-type
  [file-name]
  (let [file-name-map (URLConnection/getFileNameMap)]
    (or (.getContentTypeFor file-name-map file-name)
        "application/octet-stream")))

(defn upload
  [^DisplayVideo client advertiser-id asset]
  (let [asset-conformed (spec/check asset ::displayvideo-spec/create-asset-request)
        asset-request   (java-utils/clj->java CreateAssetRequest asset-conformed)
        filename        (:filename asset-conformed)]
    (with-open [file-input-stream (io/input-stream filename)]
      (let [asset-stream (InputStreamContent. (mime-type filename) file-input-stream)]
        (-> client
            (.advertisers)
            (.assets)
            (.upload (long advertiser-id) asset-request asset-stream)
            (sdk-client-utils/execute-and-convert)
            (spec/check ::displayvideo-spec/create-asset-response))))))
