(ns com.adgoji.line-items-assigned-targeting-options.core
  (:require
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$Advertisers$LineItems$TargetingTypes$AssignedTargetingOptions$List)
   (com.google.api.services.displayvideo.v2.model AssignedTargetingOption)))

(defn create
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long line-item-id
   ^String targeting-type
   assigned-targeting-option]
  (let [assigned-targeting-option-order-conformed
        (spec/check assigned-targeting-option ::displayvideo-spec/assigned-targeting-option)

        assigned-targeting-option-request
        (java-utils/clj->java AssignedTargetingOption
                              assigned-targeting-option-order-conformed)]
    (-> client
        (.advertisers)
        (.lineItems)
        (.targetingTypes)
        (.assignedTargetingOptions)
        (.create advertiser-id
                 line-item-id
                 targeting-type
                 assigned-targeting-option-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/assigned-targeting-option))))

(defn delete
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long line-item-id
   ^String targeting-type
   ^String assigned-targeting-option-id]
  (-> client
      (.advertisers)
      (.lineItems)
      (.targetingTypes)
      (.assignedTargetingOptions)
      (.delete advertiser-id
               line-item-id
               targeting-type
               assigned-targeting-option-id)
      (sdk-client-utils/execute-and-convert)))

(defn- fetch-assigned-targeting-options-page
  [^DisplayVideo$Advertisers$LineItems$TargetingTypes$AssignedTargetingOptions$List request
   ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-by-id
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long line-item-id
   ^String targeting-type
   ^String assigned-targeting-option-id]
  (-> client
      (.advertisers)
      (.lineItems)
      (.targetingTypes)
      (.assignedTargetingOptions)
      (.get advertiser-id
            line-item-id
            targeting-type
            assigned-targeting-option-id)
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/assigned-targeting-option)))

(defn get-list
  [^DisplayVideo client
   ^Long advertiser-id
   ^Long line-item-id
   ^String targeting-type
   {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.lineItems)
                    (.targetingTypes)
                    (.assignedTargetingOptions)
                    (.list advertiser-id line-item-id targeting-type))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$LineItems$TargetingTypes$AssignedTargetingOptions$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$LineItems$TargetingTypes$AssignedTargetingOptions$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-assigned-targeting-options-page request)
         :assigned-targeting-options
         limit)
        (spec/check ::displayvideo-spec/assigned-targeting-options))))
