(ns com.adgoji.line-items.interface
  (:require
   [com.adgoji.line-items.core :as line-items.core]))

(defn get-by-id
  [client advertiser-id line-item-id]
  (line-items.core/get-by-id client advertiser-id line-item-id))

(defn create
  [client advertiser-id line-item]
  (line-items.core/create client advertiser-id line-item))

(defn delete
  [client advertiser-id line-item-id]
  (line-items.core/delete client advertiser-id line-item-id))

(defn update-by-id
  [client advertiser-id line-item-id line-item update-mask]
  (line-items.core/update-by-id client
                                advertiser-id
                                line-item-id
                                line-item
                                update-mask))

(defn get-list
  [client advertiser-id opts]
  (line-items.core/get-list client advertiser-id opts))

(defn bulk-edit-assigned-targeting-options
  [client advertiser-id bulk-edit-assigned-targeting-options-request]
  (line-items.core/bulk-edit-assigned-targeting-options
   client
   advertiser-id
   bulk-edit-assigned-targeting-options-request))
