(ns com.adgoji.displayvideo-api.advertisers.line-items
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.line-items.interface :as line-items]))

(defn get-by-id
  "Get a single LineItem by `advertiser-id` and `line-item-id`."
  [client advertiser-id line-item-id]
  (line-items/get-by-id client advertiser-id line-item-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :line-item-id ::displayvideo-spec/line-item-id)
  :ret ::displayvideo-spec/line-item)

(defn create
  "Create a new line item."
  [client advertiser-id line-item]
  (line-items/create client advertiser-id line-item))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :line-item ::displayvideo-spec/line-item)
  :ret ::displayvideo-spec/line-item)

(defn delete
  "Delete a line item by `advertiser-id` and `line-item-id`."
  [client advertiser-id line-item-id]
  (line-items/delete client advertiser-id line-item-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :line-item-id ::displayvideo-spec/line-item-id)
  :ret (s/and map? empty?))

(defn update-by-id
  "Update an existing line item by `advertiser-id` and `line-item-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [client advertiser-id line-item-id line-item update-mask]
  (line-items/update-by-id client
                           advertiser-id
                           line-item-id
                           line-item
                           update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :line-item-id ::displayvideo-spec/line-item-id
               :line-item ::displayvideo-spec/line-item
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/line-item)

(defn get-list
  "Returns a list of all advertiser's line items."
  [client advertiser-id opts]
  (line-items/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/line-items)

(defn bulk-edit-assigned-targeting-options
  "Bulk edits targeting options under multiple line items.

  The operation will delete the assigned targeting options provided in
  `delete-requests` and then create the assigned targeting options
  provided in `create-requests`."
  [client advertiser-id bulk-edit-assigned-targeting-options-request]
  (line-items/bulk-edit-assigned-targeting-options client
                                                   advertiser-id
                                                   bulk-edit-assigned-targeting-options-request))

(s/fdef bulk-edit-assigned-targeting-options
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :bulk-edit-assigned-targeting-options-request ::displayvideo-spec/bulk-edit-assigned-options-request)
  :ret ::displayvideo-spec/bulk-edit-assigned-options-response)
