(ns com.adgoji.displayvideo-spec.displayvideo.creative
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.asset-association :as asset-association]
   [com.adgoji.displayvideo-spec.displayvideo.counter-event :as counter-event]
   [com.adgoji.displayvideo-spec.displayvideo.audio-video-offset :as audio-video-offset]
   [com.adgoji.displayvideo-spec.displayvideo.cm-tracking-ad :as cm-tracking-ad]
   [com.adgoji.displayvideo-spec.displayvideo.dimensions :as dimensions]
   [com.adgoji.displayvideo-spec.displayvideo.review-status-info :as review-status-info]
   [com.adgoji.displayvideo-spec.displayvideo.timer-event :as timer-event]
   [com.adgoji.displayvideo-spec.displayvideo.oba-icon :as oba-icon]
   [com.adgoji.displayvideo-spec.displayvideo.exit-event :as exit-event]
   [com.adgoji.displayvideo-spec.displayvideo.universal-ad-id :as universal-ad-id]
   [com.adgoji.displayvideo-spec.displayvideo.third-party-url :as third-party-url]
   [com.adgoji.displayvideo-spec.displayvideo.transcode :as transcode]))

(s/def ::name string?)
(s/def ::advertiser-id int?)
(s/def ::creative-id int?)
(s/def ::cm-placement-id int?)
(s/def ::display-name string?)
(s/def ::entity-status
  #{"ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_PAUSED"})
(s/def ::update-time string?)
(s/def ::create-time string?)

;; See
;; https://developers.google.com/display-video/api/reference/rest/v2/CreativeType
;; for details
(s/def ::creative-type
  #{"CREATIVE_TYPE_UNSPECIFIED"
    "CREATIVE_TYPE_STANDARD"
    "CREATIVE_TYPE_EXPANDABLE"
    "CREATIVE_TYPE_VIDEO"
    "CREATIVE_TYPE_NATIVE"
    "CREATIVE_TYPE_TEMPLATED_APP_INSTALL"
    "CREATIVE_TYPE_NATIVE_SITE_SQUARE"
    "CREATIVE_TYPE_TEMPLATED_APP_INSTALL_INTERSTITIAL"
    "CREATIVE_TYPE_LIGHTBOX"
    "CREATIVE_TYPE_NATIVE_APP_INSTALL"
    "CREATIVE_TYPE_NATIVE_APP_INSTALL_SQUARE"
    "CREATIVE_TYPE_AUDIO"
    "CREATIVE_TYPE_PUBLISHER_HOSTED"
    "CREATIVE_TYPE_NATIVE_VIDEO"
    "CREATIVE_TYPE_TEMPLATED_APP_INSTALL_VIDEO"})

;; See
;; https://developers.google.com/display-video/api/reference/rest/v2/advertisers.creatives#HostingSource
;; for details
(s/def ::hosting-source
  #{"HOSTING_SOURCE_UNSPECIFIED"
    "HOSTING_SOURCE_CM"
    "HOSTING_SOURCE_THIRD_PARTY"
    "HOSTING_SOURCE_HOSTED"
    "HOSTING_SOURCE_RICH_MEDIA"})

(s/def ::dynamic boolean?)
(s/def ::dimensions
  (spec/only-keys :req-un [::dimensions/width-pixels
                           ::dimensions/height-pixels]))
(s/def ::additional-dimensions
  (s/coll-of ::dimensions :distinct true :into []))
(s/def ::media-duration string?)
(s/def ::creative-attribute
  #{"CREATIVE_ATTRIBUTE_UNSPECIFIED"
    "CREATIVE_ATTRIBUTE_VAST"
    "CREATIVE_ATTRIBUTE_VPAID_LINEAR"
    "CREATIVE_ATTRIBUTE_VPAID_NON_LINEAR"})
(s/def ::creative-attributes
  (s/coll-of ::creative-attribute :distinct true :into []))
(s/def ::review-status
  (spec/only-keys :req-un [::review-status-info/approval-status
                           ::review-status-info/creative-and-landing-page-review-status
                           ::review-status-info/exchange-review-statuses]
                  :opt-un [::review-status-info/content-and-policy-review-status
                           ::review-status-info/publisher-review-statuses]))
(s/def ::asset-association
  (spec/only-keys :req-un [::asset-association/asset
                           ::asset-association/role]))
(s/def ::assets
  (s/coll-of ::asset-association :distinct true :into []))
(s/def ::exit-event
  (spec/only-keys :req-un [::exit-event/type
                           ::exit-event/url]
                  :opt-un [::exit-event/name
                           ::exit-event/reporting-name]))
(s/def ::exit-events
  (s/coll-of ::exit-event :distinct true :into []))
(s/def ::timer-event
  (spec/only-keys :req-un [::timer-event/name
                           ::timer-event/reporting-name]))
(s/def ::timer-events
  (s/coll-of ::timer-event :distinct true :into []))
(s/def ::counter-event
  (spec/only-keys :req-un [::counter-event/name
                           ::counter-event/reporting-name]))
(s/def ::counter-events
  (s/coll-of ::counter-event :distinct true :into []))
(s/def ::appended-tag string?)
(s/def ::integration-code string?)
(s/def ::notes string?)
(s/def ::ias-campaign-monitoring boolean?)
(s/def ::companion-creative-ids
  (s/coll-of ::creative-id :distinct true :into []))
(s/def ::skippable boolean?)
(s/def ::skip-offset
  (spec/only-keys :req-un []))

(defmulti audio-video-offset-spec keys)

(defmethod audio-video-offset-spec '(:percentage)
  [_]
  (spec/only-keys :req-un [::audio-video-offset/percentage]))

(defmethod audio-video-offset-spec '(:seconds)
  [_]
  (spec/only-keys :req-un [::audio-video-offset/seconds]))

(s/def ::audio-video-offset
  (s/multi-spec audio-video-offset-spec ::audio-video-offset))
(s/def ::skip-offset ::audio-video-offset)
(s/def ::progress-offset ::audio-video-offset)
(s/def ::universal-ad-id
  (spec/only-keys :req-un [::universal-ad-id/id
                           ::universal-ad-id/registry]))
(s/def ::third-party-url
  (spec/only-keys :req-un [::third-party-url/type
                           ::third-party-url/url]))
(s/def ::third-party-urls
  (s/coll-of ::third-party-url :distinct true :into []))
(s/def ::transcode
  (spec/only-keys :opt-un [::transcode/name
                           ::transcode/mime-type
                           ::transcode/transcoded
                           ::transcode/dimensions
                           ::transcode/bit-rate-kbps
                           ::transcode/frame-rate
                           ::transcode/audio-bit-rate-kbps
                           ::transcode/audio-sample-rate-hz
                           ::transcode/file-size-bytes]))
(s/def ::transcodes
  (s/coll-of ::transcode :distinct true :into []))
(s/def ::tracker-urls
  (s/coll-of string? :distinct true :into []))
(s/def ::js-tracker-url string?)
(s/def ::cm-tracking-ad
  (spec/only-keys :req-un [::cm-tracking-ad/cm-placement-id
                           ::cm-tracking-ad/cm-creative-id
                           ::cm-tracking-ad/cm-ad-id]))
(s/def ::oba-icon
  (spec/only-keys :req-un [::oba-icon/landing-page-url
                           ::oba-icon/click-tracking-url
                           ::oba-icon/view-tracking-url]
                  :opt-un [::oba-icon/resource-url
                           ::oba-icon/resource-mime-type
                           ::oba-icon/position
                           ::oba-icon/dimensions
                           ::oba-icon/program]))
(s/def ::third-party-tag string?)
(s/def ::require-mraid boolean?)
(s/def ::require-html5 boolean?)
(s/def ::require-ping-for-attribution boolean?)
(s/def ::expanding-direction
  #{"EXPANDING_DIRECTION_UNSPECIFIED"
    "EXPANDING_DIRECTION_NONE"
    "EXPANDING_DIRECTION_UP"
    "EXPANDING_DIRECTION_DOWN"
    "EXPANDING_DIRECTION_LEFT"
    "EXPANDING_DIRECTION_RIGHT"
    "EXPANDING_DIRECTION_UP_AND_LEFT"
    "EXPANDING_DIRECTION_UP_AND_RIGHT"
    "EXPANDING_DIRECTION_DOWN_AND_LEFT"
    "EXPANDING_DIRECTION_DOWN_AND_RIGHT"
    "EXPANDING_DIRECTION_UP_OR_DOWN"
    "EXPANDING_DIRECTION_LEFT_OR_RIGHT"
    "EXPANDING_DIRECTION_ANY_DIAGONAL"})
(s/def ::expand-on-hover boolean?)
(s/def ::vast-tag-url string?)
(s/def ::vpaid boolean?)
(s/def ::html5-video boolean?)
(s/def ::line-item-ids
  (s/coll-of int? :distinct true :into []))
(s/def ::mp3-audio boolean?)
(s/def ::ogg-audio boolean?)
