(ns com.adgoji.displayvideo-spec.displayvideo.campaign
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.goal :as campaign.goal]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.flight :as campaign.flight]
   [com.adgoji.displayvideo-spec.displayvideo.campaign.budget :as campaign.budget]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap :as frequency-cap]))

(s/def ::name string?)
(s/def ::campaign-id int?)
(s/def ::display-name string?)
(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)
(s/def ::campaign-goal
  (spec/only-keys :req-un [::campaign.goal/campaign-goal-type
                           ::campaign.goal/performance-goal]))

(s/def ::campaign-flight
  (spec/only-keys :req-un [::campaign.flight/planned-dates]
                  :opt-un [::campaign.flight/planned-spend-amount-micros]))

(s/def ::campaign-budget
  (spec/only-keys :req-un [::campaign.budget/display-name
                           ::campaign.budget/budget-unit
                           ::campaign.budget/budget-amount-micros
                           ::campaign.budget/date-range
                           ::campaign.budget/external-budget-source
                           ::campaign.budget/prisma-config]
                  :opt-un [::campaign.budget/budget-id
                           ::campaign.budget/external-budget-id
                           ::campaign.budget/invoice-grouping-id]))

(s/def ::campaign-budgets
  (s/coll-of ::campaign-budget :into []))

(defmulti frequency-cap-spec :unlimited)

(defmethod frequency-cap-spec true
  [_]
  (spec/only-keys :opt-un [::frequency-cap/unlimited]))

(defmethod frequency-cap-spec false
  [_]
  (spec/only-keys :req-un [::frequency-cap/time-unit
                           ::frequency-cap/time-unit-count]
                  :opt-un [::frequency-cap/unlimited
                           ::frequency-cap/max-impressions
                           ::frequency-cap/max-views]))
(defmethod frequency-cap-spec nil
  [_]
  (spec/only-keys :req-un [::frequency-cap/time-unit
                           ::frequency-cap/time-unit-count]
                  :opt-un [::frequency-cap/unlimited
                           ::frequency-cap/max-impressions
                           ::frequency-cap/max-views]))

(s/def ::frequency-cap
  (s/multi-spec frequency-cap-spec ::frequency-cap))
