(ns com.adgoji.displayvideo-api.advertisers.insertion-orders.assigned-targeting-options
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.insertion-orders-assigned-targeting-options.interface
    :as
    assigned-targeting-options]))

(defn create
  [client advertiser-id insertion-order-id targeting-type assigned-targeting-option]
  (assigned-targeting-options/create client
                                     advertiser-id
                                     insertion-order-id
                                     targeting-type
                                     assigned-targeting-option))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id
               :targeting-type ::displayvideo-spec/targeting-type
               :assigned-targeting-option ::displayvideo-spec/assigned-targeting-option)
  :ret ::displayvideo-spec/assigned-targeting-option)

(defn delete
  "Delete an assigned-targeting-option by `advertiser-id` and
  `assigned-targeting-option-id`."
  [client advertiser-id insertion-order-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/delete client
                                     advertiser-id
                                     insertion-order-id
                                     targeting-type
                                     assigned-targeting-option-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id
               :targeting-type ::displayvideo-spec/targeting-type
               :assigned-targeting-option-id ::displayvideo-spec/assigned-targeting-option-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Returns a single assigned-targeting-option by `assigned-targeting-option-id`."
  [client advertiser-id insertion-order-id targeting-type assigned-targeting-option-id]
  (assigned-targeting-options/get-by-id client
                                        advertiser-id
                                        insertion-order-id
                                        targeting-type
                                        assigned-targeting-option-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id
               :targeting-type ::displayvideo-spec/targeting-type
               :assigned-targeting-option-id ::displayvideo-spec/assigned-targeting-option-id)
  :ret ::displayvideo-spec/assigned-targeting-option)

(defn get-list
  "Returns a list of all assigned targeting options of an insertion order"
  [client advertiser-id insertion-order-id targeting-type opts]
  (assigned-targeting-options/get-list client
                                       advertiser-id
                                       insertion-order-id
                                       targeting-type opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id
               :targeting-type ::displayvideo-spec/targeting-type
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/assigned-targeting-options)
