(ns com.adgoji.spec.utils
  (:require
   [clojure.spec.alpha :as s]))

(defn check
  [v spec]
  (let [parsed (s/conform spec v)]
    (if (s/invalid? parsed)
      (throw (ex-info "Spec check failed" (s/explain-data spec v)))
      parsed)))

(defmacro only-keys
  [& {:keys [req req-un opt opt-un] :as args}]
  `(s/merge (s/map-of ~(set (concat req
                                    (map (comp keyword name) req-un)
                                    opt
                                    (map (comp keyword name) opt-un)))
                      any?)
            (s/keys ~@(apply concat (vec args)))))
