(ns com.adgoji.spec.displayvideo.campaign.budget
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.displayvideo.date-range :as date-range]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.prisma-config :as prisma-config]))

(s/def ::budget-id int?)
(s/def ::display-name string?)
(s/def ::budget-unit
  #{"BUDGET_UNIT_UNSPECIFIED"
    "BUDGET_UNIT_CURRENCY"
    "BUDGET_UNIT_IMPRESSIONS"})
(s/def ::budget-amount-micros int?)
(s/def ::date-range
  (spec.utils/only-keys :req-un [::date-range/start-date]
                        :opt-un [::date-range/end-date]))

(s/def ::external-budget-source
  #{"EXTERNAL_BUDGET_SOURCE_UNSPECIFIED"
    "EXTERNAL_BUDGET_SOURCE_NONE"
    "EXTERNAL_BUDGET_SOURCE_MEDIA_OCEAN"})

(s/def ::external-budget-id string?)
(s/def ::invoice-grouping-id string?)
(s/def ::prisma-config
  (spec.utils/only-keys :req-un [::prisma-config/prisma-type
                                 ::prisma-config/prisma-cpe-code
                                 ::prisma-config/supplier]))
