(ns com.adgoji.spec.displayvideo.bidding-strategy
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.maximize-spend-bid-strategy :as maximize-spend-bid-strategy]
   [com.adgoji.spec.displayvideo.fixed-bid-strategy :as fixed-bid-strategy]
   [com.adgoji.spec.displayvideo.performance-goal-bid-strategy :as performance-goal-bid-strategy]))

(s/def ::maximize-spend-auto-bid
  (spec.utils/only-keys :req-un [::maximize-spend-bid-strategy/performance-goal-type]
                        :opt-un [::maximize-spend-bid-strategy/custom-bidding-algotithm-id
                                 ::maximize-spend-bid-strategy/max-average-cpm-bid-amount-micros
                                 ::maximize-spend-bid-strategy/raise-bid-for-deals]))

(s/def ::fixed-bid
  (spec.utils/only-keys :opt-un [::fixed-bid-strategy/bid-amount-micros]))

(s/def ::performance-goal-auto-bid
  (spec.utils/only-keys :req-un [::performance-goal-bid-strategy/performance-goal-amount-micros
                                 ::performance-goal-bid-strategy/performance-goal-type]
                        :opt-un [::performance-goal-bid-strategy/custom-bidding-algotithm-id
                                 ::performance-goal-bid-strategy/max-average-cpm-bid-amount-micros]))
