(ns  com.adgoji.spec.displayvideo.assigned-targeting-option
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.displayvideo.age-range-assigned-targeting-option-details
    :as age-range-details]
   [com.adgoji.spec.displayvideo.app-assigned-targeting-option-details
    :as app-details]
   [com.adgoji.spec.displayvideo.audience-group-assigned-targeting-option-details
    :as audience-group-details]
   [com.adgoji.spec.displayvideo.audio-content-type-assigned-targeting-option-details
    :as audio-content-type-details]
   [com.adgoji.spec.displayvideo.authorized-seller-status-assigned-targeting-option-details
    :as authorized-seller-status-details]
   [com.adgoji.spec.displayvideo.channel-assigned-targeting-option-details
    :as channel-details]
   [com.adgoji.spec.displayvideo.common-assigned-targeting-option-details
    :as common-details]
   [com.adgoji.spec.displayvideo.content-duration-assigned-targeting-option-details
    :as content-duration-details]
   [com.adgoji.spec.displayvideo.content-instream-position-assigned-targeting-option-details
    :as content-instream-position-details]
   [com.adgoji.spec.displayvideo.content-outstream-position-assigned-targeting-option-details
    :as content-outstream-position-details]
   [com.adgoji.spec.displayvideo.content-stream-type-assigned-targeting-option-details
    :as content-stream-type-details]
   [com.adgoji.spec.displayvideo.day-and-time-assigned-targeting-option-details
    :as day-and-time-details]
   [com.adgoji.spec.displayvideo.device-type-assigned-targeting-option-details
    :as device-type-details]
   [com.adgoji.spec.displayvideo.digital-content-label-exclusion-assigned-targeting-option-details
    :as digital-content-label-exclusion-details]
   [com.adgoji.spec.displayvideo.environment-assigned-targeting-option-details
    :as environment-details]
   [com.adgoji.spec.displayvideo.exchange-assigned-targeting-option-details
    :as exchange-details]
   [com.adgoji.spec.displayvideo.gender-assigned-targeting-option-details
    :as gender-details]
   [com.adgoji.spec.displayvideo.geo-region-assigned-targeting-option-details
    :as geo-region-details]
   [com.adgoji.spec.displayvideo.household-income-assigned-targeting-option-details
    :as household-income-details]
   [com.adgoji.spec.displayvideo.inventory-source-assigned-targeting-option-details
    :as inventory-source-details]
   [com.adgoji.spec.displayvideo.inventory-source-group-assigned-targeting-option-details
    :as inventory-source-group-details]
   [com.adgoji.spec.displayvideo.keyword-assigned-targeting-option-details
    :as keyword-details]
   [com.adgoji.spec.displayvideo.native-content-position-assigned-targeting-option-details
    :as native-content-position-details]
   [com.adgoji.spec.displayvideo.negative-keyword-list-assigned-targeting-option-details
    :as negative-keyword-list-details]
   [com.adgoji.spec.displayvideo.omid-assigned-targeting-option-details
    :as omid-details]
   [com.adgoji.spec.displayvideo.on-screen-position-assigned-targeting-option-details
    :as on-screen-position-details]
   [com.adgoji.spec.displayvideo.parental-status-assigned-targeting-option-details
    :as parental-status-details]
   [com.adgoji.spec.displayvideo.poi-assigned-targeting-option-details
    :as poi-details]
   [com.adgoji.spec.displayvideo.proximity-location-list-assigned-targeting-option-details
    :as proximity-location-list-details]
   [com.adgoji.spec.displayvideo.regional-location-list-assigned-targeting-option-details
    :as regional-location-list-details]
   [com.adgoji.spec.displayvideo.sensitive-category-exclusion-assigned-targeting-option-details
    :as sensitive-category-exclusion-details]
   [com.adgoji.spec.displayvideo.session-position-assigned-targeting-option-details
    :as session-position-details]
   [com.adgoji.spec.displayvideo.third-party-verifier-assigned-targeting-option-details
    :as third-party-verifier-details]
   [com.adgoji.spec.displayvideo.url-assigned-targeting-option
    :as url-details]
   [com.adgoji.spec.displayvideo.user-rewarded-content-assigned-targeting-option-details
    :as user-rewarded-content-details]
   [com.adgoji.spec.displayvideo.video-player-size-assigned-targeting-option-details
    :as video-player-size-details]
   [com.adgoji.spec.displayvideo.viewability-assigned-targeting-option-details
    :as viewability-details]
   [com.adgoji.spec.displayvideo.youtube-channel-assigned-targeting-option-details
    :as youtube-channel-details]
   [com.adgoji.spec.displayvideo.youtube-video-assigned-targeting-option-details
    :as youtube-video-details]
   [com.adgoji.spec.utils :as spec.utils]))

(s/def ::name string?)

(s/def ::assigned-targeting-option-id string?)

(s/def ::assigned-targeting-option-id-alias string?)

(s/def ::targeting-type
  #{"TARGETING_TYPE_UNSPECIFIED"
    "TARGETING_TYPE_CHANNEL"
    "TARGETING_TYPE_APP_CATEGORY"
    "TARGETING_TYPE_APP"
    "TARGETING_TYPE_URL"
    "TARGETING_TYPE_DAY_AND_TIME"
    "TARGETING_TYPE_AGE_RANGE"
    "TARGETING_TYPE_REGIONAL_LOCATION_LIST"
    "TARGETING_TYPE_PROXIMITY_LOCATION_LIST"
    "TARGETING_TYPE_GENDER"
    "TARGETING_TYPE_VIDEO_PLAYER_SIZE"
    "TARGETING_TYPE_USER_REWARDED_CONTENT"
    "TARGETING_TYPE_PARENTAL_STATUS"
    "TARGETING_TYPE_CONTENT_INSTREAM_POSITION"
    "TARGETING_TYPE_CONTENT_OUTSTREAM_POSITION"
    "TARGETING_TYPE_DEVICE_TYPE"
    "TARGETING_TYPE_AUDIENCE_GROUP"
    "TARGETING_TYPE_BROWSER"
    "TARGETING_TYPE_HOUSEHOLD_INCOME"
    "TARGETING_TYPE_ON_SCREEN_POSITION"
    "TARGETING_TYPE_THIRD_PARTY_VERIFIER"
    "TARGETING_TYPE_DIGITAL_CONTENT_LABEL_EXCLUSION"
    "TARGETING_TYPE_SENSITIVE_CATEGORY_EXCLUSION"
    "TARGETING_TYPE_ENVIRONMENT"
    "TARGETING_TYPE_CARRIER_AND_ISP"
    "TARGETING_TYPE_OPERATING_SYSTEM"
    "TARGETING_TYPE_DEVICE_MAKE_MODEL"
    "TARGETING_TYPE_KEYWORD"
    "TARGETING_TYPE_NEGATIVE_KEYWORD_LIST"
    "TARGETING_TYPE_VIEWABILITY"
    "TARGETING_TYPE_CATEGORY"
    "TARGETING_TYPE_INVENTORY_SOURCE"
    "TARGETING_TYPE_LANGUAGE"
    "TARGETING_TYPE_AUTHORIZED_SELLER_STATUS"
    "TARGETING_TYPE_GEO_REGION"
    "TARGETING_TYPE_INVENTORY_SOURCE_GROUP"
    "TARGETING_TYPE_EXCHANGE"
    "TARGETING_TYPE_SUB_EXCHANGE"
    "TARGETING_TYPE_POI"
    "TARGETING_TYPE_BUSINESS_CHAIN"
    "TARGETING_TYPE_CONTENT_DURATION"
    "TARGETING_TYPE_CONTENT_STREAM_TYPE"
    "TARGETING_TYPE_NATIVE_CONTENT_POSITION"
    "TARGETING_TYPE_OMID"
    "TARGETING_TYPE_AUDIO_CONTENT_TYPE"
    "TARGETING_TYPE_CONTENT_GENRE"
    "TARGETING_TYPE_YOUTUBE_VIDEO"
    "TARGETING_TYPE_YOUTUBE_CHANNEL"
    "TARGETING_TYPE_SESSION_POSITION"})

(s/def ::inheritance
  #{"INHERITANCE_UNSPECIFIED"
    "INHERITED_FROM_PARTNER"
    "NOT_INHERITED"
    "INHERITED_FROM_ADVERTISER"})

;; Union field of details starts here.

(s/def ::channel-details
  (spec.utils/only-keys :req-un [::channel-details/channel-id]
                        :opt-un [::common-details/negative]))

(s/def ::app-category-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::app-details
  (spec.utils/only-keys :req-un [::app-details/app-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative
                                 ::app-details/app-platform]))

(s/def ::url-details
  (spec.utils/only-keys :req-un [::url-details/url]
                        :opt-un [::common-details/negative]))

(s/def ::day-and-time-details
  (spec.utils/only-keys :req-un [::day-and-time-details/day-of-week
                                 ::day-and-time-details/start-hour
                                 ::day-and-time-details/end-hour
                                 ::day-and-time-details/time-zone-resolution]))

(s/def ::age-range-details
  (spec.utils/only-keys :req-un [::age-range-details/age-range]))

(s/def ::regional-location-list-details
  (spec.utils/only-keys :req-un [::regional-location-list-details/regional-location-list-id]
                        :opt-un [::common-details/negative]))

(s/def ::proximity-location-list-details
  (spec.utils/only-keys :req-un [::proximity-location-list-details/proximity-location-list-id
                                 ::proximity-location-list-details/proximity-radius
                                 ::proximity-location-list-details/proximity-radius-unit]))

(s/def ::gender-details
  (spec.utils/only-keys :req-un [::gender-details/gender]))

(s/def ::video-player-size-details
  (spec.utils/only-keys :req-un [::video-player-size-details/video-player-size]))

(s/def ::user-rewarded-content-details
  (spec.utils/only-keys :req-un [::user-rewarded-content-details/targeting-option-id]
                        :opt-un [::user-rewarded-content-details/user-rewarded-content]))

(s/def ::parental-status-details
  (spec.utils/only-keys :req-un [::parental-status-details/parental-status]))

(s/def ::content-instream-position-details
  (spec.utils/only-keys :req-un [::content-instream-position-details/content-instream-position]
                        :opt-un [::common-details/ad-type]))

(s/def ::content-outstream-position-details
  (spec.utils/only-keys :req-un [::content-outstream-position-details/content-outstream-position]
                        :opt-un [::common-details/ad-type]))

(s/def ::device-type-details
  (spec.utils/only-keys :req-un [::device-type-details/device-type]
                        :opt-un [::device-type-details/youtube-and-partners-bid-multiplier]))

(s/def ::audience-group-details
  (spec.utils/only-keys :opt-un [::audience-group-details/included-first-and-third-party-audience-groups
                                 ::audience-group-details/included-google-audience-group
                                 ::audience-group-details/included-custom-list-group
                                 ::audience-group-details/included-combined-audience-group
                                 ::audience-group-details/excluded-first-and-third-party-audience-groups
                                 ::audience-group-details/excluded-google-audience-group]))

(s/def ::browser-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::household-income-details
  (spec.utils/only-keys :req-un [::household-income-details/household-income]))

(s/def ::on-screen-position-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::on-screen-position-details/on-screen-position
                                 ::common-details/ad-type]))

(s/def ::carrier-and-isp-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))
(s/def ::keyword-details
  (spec.utils/only-keys :req-un [::keyword-details/keyword]
                        :opt-un [::common-details/negative]))

(s/def ::negative-keyword-list-details
  (spec.utils/only-keys :req-un [::negative-keyword-list-details/negative-keyword-list-id]))

(s/def ::operating-system-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::device-make-model-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::environment-details
  (spec.utils/only-keys :req-un [::environment-details/environment]))

(s/def ::inventory-source-details
  (spec.utils/only-keys :req-un [::inventory-source-details/inventory-source-id]))

(s/def ::category-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::viewability-details
  (spec.utils/only-keys :req-un [::viewability-details/viewability]))

(s/def ::authorized-seller-status-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::authorized-seller-status-details/authorized-seller-status]))

(s/def ::language-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::geo-region-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::geo-region-details/geo-region-type
                                 ::common-details/negative]))

(s/def ::inventory-source-group-details
  (spec.utils/only-keys :req-un [::inventory-source-group-details/inventory-source-group-id]))

(s/def ::digital-content-label-exclusion-details
  (spec.utils/only-keys :req-un [::digital-content-label-exclusion-details/excluded-content-rating-tier]))

(s/def ::sensitive-category-exclusion-details
  (spec.utils/only-keys :req-un [::sensitive-category-exclusion-details/excluded-sensitive-category]))

(s/def ::exchange-details
  (spec.utils/only-keys :req-un [::exchange-details/exchange]))

(s/def ::sub-exchange-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]))

;;TODO change to `defmulti`
(s/def ::third-party-verifier-details
  (spec.utils/only-keys :opt-un [::third-party-verifier-details/adloox
                                 ::third-party-verifier-details/double-verify
                                 ::third-party-verifier-details/integral-ad-science]))

(s/def ::poi-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::poi-details/latitude
                                 ::poi-details/longitude
                                 ::common-details/proximity-radius-amount
                                 ::common-details/proximity-radius-unit]))

(s/def ::business-chain-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id
                                 ::common-details/proximity-radius-amount
                                 ::common-details/proximity-radius-unit]
                        :opt-un [::common-details/display-name]))

(s/def ::content-duration-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::content-duration-details/content-duration]))

(s/def ::content-stream-type-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::content-stream-type-details/content-stream-type]))

(s/def ::native-content-position-details
  (spec.utils/only-keys :req-un [::native-content-position-details/content-position]))

(s/def ::omid-details
  (spec.utils/only-keys :req-un [::omid-details/omid]))

(s/def ::audio-content-type-details
  (spec.utils/only-keys :req-un [::audio-content-type-details/audio-content-type]))

(s/def ::content-genre-details
  (spec.utils/only-keys :req-un [::common-details/targeting-option-id]
                        :opt-un [::common-details/display-name
                                 ::common-details/negative]))

(s/def ::youtube-video-details
  (spec.utils/only-keys :opt-un [::youtube-video-details/video-id
                                 ::common-details/negative]))

(s/def ::youtube-channel-details
  (spec.utils/only-keys :opt-un [::youtube-channel-details/channel-id
                                 ::common-details/negative]))

(s/def ::session-position-details
  (spec.utils/only-keys :opt-un [::session-position-details/session-position]))

;; End of list of possible types for union field details
