(ns com.adgoji.displayvideo-api.advertisers.line-items
  (:require
   [com.adgoji.line-items.interface :as line-items]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn get-by-id
  "Get a single LineItem by `advertiser-id` and `line-item-id`."
  [^DisplayVideo client advertiser-id line-item-id]
  (line-items/get-by-id client advertiser-id line-item-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :line-item-id ::spec/line-item-id)
  :ret ::spec/line-item)

(defn create
  "Create a new line item."
  [^DisplayVideo client advertiser-id line-item]
  (line-items/create client advertiser-id line-item))

(s/fdef create
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :line-item ::spec/line-item)
  :ret ::spec/line-item)

(defn delete
  "Delete a line item by `advertiser-id` and `line-item-id`."
  [^DisplayVideo client advertiser-id line-item-id]
  (line-items/delete client advertiser-id line-item-id))

(s/fdef delete
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :line-item-id ::spec/line-item-id)
  :ret (s/and map? empty?))

(defn update-by-id
  "Update an existing line item by `advertiser-id` and `line-item-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [^DisplayVideo client advertiser-id line-item-id line-item update-mask]
  (line-items/update-by-id client
                           advertiser-id
                           line-item-id
                           line-item
                           update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :line-item-id ::spec/line-item-id
               :line-item ::spec/line-item
               :update-mask ::spec/update-mask)
  :ret ::spec/line-item)

(defn get-list
  "Returns a list of all advertiser's line items."
  [^DisplayVideo client advertiser-id opts]
  (line-items/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/line-items)
