(ns com.adgoji.spec.displayvideo.youtube-and-partners-settings
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.youtube-and-partners-bidding-strategy :as youtube-and-partners-bidding-strategy]
   [com.adgoji.spec.displayvideo.frequency-cap :as frequency-cap]
   [com.adgoji.spec.displayvideo.youtube-and-partners-third-party-measurement-settings :as youtube-and-partners-third-party-measurement-settings]
   [com.adgoji.spec.displayvideo.youtube-and-partners-inventory-source-config :as youtube-and-partners-inventory-source-config]
   [com.adgoji.spec.displayvideo.target-frequency :as target-frequency]
   [com.adgoji.spec.displayvideo.video-ad-sequence-settings :as video-ad-sequence-settings]))

(s/def ::bidding-strategy
  (spec.utils/only-keys
   :opt-un [::youtube-and-partners-bidding-strategy/bidding_strategy-type
            ::youtube-and-partners-bidding-strategy/target-cpa-source
            ::youtube-and-partners-bidding-strategy/target-cpa-value
            ::youtube-and-partners-bidding-strategy/value]))

(s/def ::frequency-cap
  (spec.utils/only-keys
   :opt-un [::frequency-cap/max-impressions
            ::frequency-cap/max-views
            ::frequency-cap/time-unit
            ::frequency-cap/time-unit-count
            ::frequency-cap/unlimited]))

(s/def ::third-party-measurement-settings
  (spec.utils/only-keys
   :opt-un [::youtube-and-partners-third-party-measurement-settings/brandlift-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/brandsafety-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/reach-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/viewability-vendor-configs]))

(s/def ::inventory-source-settings
  (spec.utils/only-keys
   :opt-un [::youtube-and-partners-inventory-source-config/youtube-search
            ::youtube-and-partners-inventory-source-config/youtube-videos
            ::youtube-and-partners-inventory-source-config/youtube-videos-partners]))

(s/def ::content-category
  #{"YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_UNSPECIFIED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_STANDARD"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_EXPANDED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_LIMITED"})

(s/def ::target-frequency
  (spec.utils/only-keys :opt-un [::target-frequency/target-count
                                 ::target-frequency/time-unit
                                 ::target-frequency/time-unit-count]))

(s/def ::linked-merchant-id int?)
(s/def ::related-video-ids
  (s/coll-of int? :distinct true :into []))
(s/def ::lead-form-id int?)

(s/def ::video-ad-sequence-settings
  (spec.utils/only-keys :opt-un [::video-ad-sequence-settings/minimum-duration
                                 ::video-ad-sequence-settings/steps]))
