(ns com.adgoji.insertion-orders.core
  (:require
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [camel-snake-kebab.core :as csk]
   [clojure.string :as str])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$Advertisers$InsertionOrders$List)
   (com.google.api.services.displayvideo.v2.model InsertionOrder)))

(defn create
  [^DisplayVideo client advertiser-id insertion-order]
  (let [insertion-order-conformed
        (spec/check insertion-order ::spec/insertion-order)

        insertion-order-request
        (java-utils/clj->java InsertionOrder
                              insertion-order-conformed)]
    (-> client
        (.advertisers)
        (.insertionOrders)
        (.create advertiser-id insertion-order-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::spec/insertion-order))))

(defn delete
  [^DisplayVideo client advertiser-id insertion-order-id]
  (-> client
      (.advertisers)
      (.insertionOrders)
      (.delete advertiser-id insertion-order-id)
      (sdk-client-utils/execute-and-convert)))

(defn- fetch-insertion-orders-page
  [^DisplayVideo$Advertisers$InsertionOrders$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-by-id
  [^DisplayVideo client advertiser-id insertion-order-id]
  (-> client
      (.advertisers)
      (.insertionOrders)
      (.get advertiser-id insertion-order-id)
      (sdk-client-utils/execute-and-convert)
      (spec/check ::spec/insertion-order)))

(defn get-list
  [^DisplayVideo client advertiser-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.insertionOrders)
                    (.list advertiser-id))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$InsertionOrders$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$InsertionOrders$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated (partial fetch-insertion-orders-page request)
                                                        :insertion-orders
                                                        limit)
        (spec/check ::spec/insertion-orders))))

(defn update-by-id
  [^DisplayVideo client advertiser-id insertion-order-id insertion-order update-mask]
  (let [mask-conformed          (spec/check update-mask ::spec/update-mask)
        mask                    (->> mask-conformed
                                     (sequence (map csk/->camelCaseString))
                                     (str/join \,))
        insertion-order-request (java-utils/clj->java InsertionOrder insertion-order)]
    (-> client
        (.advertisers)
        (.insertionOrders)
        (.patch advertiser-id insertion-order-id insertion-order-request)
        (.setUpdateMask mask)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::spec/insertion-order))))
