(ns com.adgoji.assets.core
  (:import
   (java.net URLConnection)
   (com.google.api.services.displayvideo.v2 DisplayVideo)
   com.google.api.services.displayvideo.v2.model.CreateAssetRequest
   com.google.api.client.http.InputStreamContent)
  (:require
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [clojure.java.io :as io]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]))

(defn- mime-type
  [file-name]
  (let [file-name-map (URLConnection/getFileNameMap)]
    (or (.getContentTypeFor file-name-map file-name)
        "application/octet-stream")))

(defn upload
  [^DisplayVideo client advertiser-id asset]
  (let [asset-conformed (spec/check asset ::spec/create-asset-request)
        asset-request   (java-utils/clj->java CreateAssetRequest asset-conformed)
        filename        (:filename asset-conformed)]
    (with-open [file-input-stream (io/input-stream filename)]
      (let [asset-stream (InputStreamContent. (mime-type filename) file-input-stream)]
        (-> client
            (.advertisers)
            (.assets)
            (.upload advertiser-id asset-request asset-stream)
            (sdk-client-utils/execute-and-convert)
            (spec/check ::spec/create-asset-response))))))
