(ns com.adgoji.line-items.interface
  (:require
   [com.adgoji.line-items.core :as line-items.core])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn get-by-id
  [^DisplayVideo client advertiser-id line-item-id]
  (line-items.core/get-by-id client advertiser-id line-item-id))

(defn create
  [^DisplayVideo client advertiser-id line-item]
  (line-items.core/create client advertiser-id line-item))

(defn delete
  [^DisplayVideo client advertiser-id line-item-id]
  (line-items.core/delete client advertiser-id line-item-id))

(defn update-by-id
  [^DisplayVideo client advertiser-id line-item-id line-item update-mask]
  (line-items.core/update-by-id client
                                advertiser-id
                                line-item-id
                                line-item
                                update-mask))

(defn get-list
  [^DisplayVideo client advertiser-id opts]
  (line-items.core/get-list client advertiser-id opts))
