(ns com.adgoji.displayvideo-api.advertisers.location-lists
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.advertisers-location-lists.interface :as location-lists]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]))

(defn create
  "Creates a new location list. Returns the newly created location list if
  successful."
  [client advertiser-id location-list]
  (location-lists/create client advertiser-id location-list))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list ::displayvideo-spec/location-list)
  :ret ::displayvideo-spec/location-list)

(defn get-by-id
  "Gets a location-list by `advertiser-id` and `location-list-id`."
  [client advertiser-id location-list-id]
  (location-lists/get-by-id client advertiser-id location-list-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id)
  :ret ::displayvideo-spec/location-list)

(defn get-list
  "Lists location lists based on a given advertiser id."
  [client advertiser-id opts]
  (location-lists/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/location-lists)

(defn update-by-id
  "Updates an existing location-list by `advertiser-id` and `location-list-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [client advertiser-id location-list-id location-list update-mask]
  (location-lists/update-by-id client
                               advertiser-id
                               location-list-id
                               location-list
                               update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :location-list-id ::displayvideo-spec/location-list-id
               :location-list ::displayvideo-spec/location-list-update
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/location-list)
