(ns com.adgoji.displayvideo-spec.displayvideo.line-item
  (:require
   [com.adgoji.displayvideo-spec.displayvideo.creative :as creative]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.bidding-strategy :as bidding-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.line-item.budget :as line-item.budget]
   [com.adgoji.displayvideo-spec.displayvideo.line-item.flight :as line-item.flight]
   [com.adgoji.displayvideo-spec.displayvideo.mobile-app :as mobile-app]
   [com.adgoji.displayvideo-spec.displayvideo.pacing :as pacing]
   [com.adgoji.displayvideo-spec.displayvideo.partner-revenue-model :as partner-revenue-model]
   [com.adgoji.displayvideo-spec.displayvideo.conversion-counting-config :as conversion-counting-config]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.partner-costs :as partner-costs]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-expansion-config :as targeting-expansion-config]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-settings :as youtube-and-partners-settings]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.displayvideo-spec.displayvideo.campaign :as campaign]))

(s/def ::name string?)
(s/def ::insertion-order-id int?)
(s/def ::line-item-id int?)
(s/def ::line-item-ids (s/coll-of ::line-item-id :distinct true :into []))
(s/def ::display-name string?)
(s/def ::update-time string?)
(s/def ::exclude-new-exchanges boolean?)

(s/def ::creative-ids
  (s/coll-of ::creative/creative-id :dintinct true :into []))

(s/def ::warning-messages
  (s/coll-of ::message :distinct true :into []))

(s/def ::message
  #{"LINE_ITEM_WARNING_MESSAGE_UNSPECIFIED"
    "INVALID_FLIGHT_DATES"
    "EXPIRED"
    "PENDING_FLIGHT"
    "ALL_PARTNER_ENABLED_EXCHANGES_NEGATIVELY_TARGETED"
    "INVALID_INVENTORY_SOURCE"
    "APP_INVENTORY_INVALID_SITE_TARGETING"
    "APP_INVENTORY_INVALID_AUDIENCE_LISTS"
    "NO_VALID_CREATIVE"
    "PARENT_INSERTION_ORDER_PAUSED"
    "PARENT_INSERTION_ORDER_EXPIRED"
    "DEPRECATED_FIRST_PARTY_AUDIENCE_EXCLUSION"})

(s/def ::line-item-type
  #{"LINE_ITEM_TYPE_UNSPECIFIED"
    "LINE_ITEM_TYPE_DISPLAY_DEFAULT"
    "LINE_ITEM_TYPE_DISPLAY_MOBILE_APP_INSTALL"
    "LINE_ITEM_TYPE_VIDEO_DEFAULT"
    "LINE_ITEM_TYPE_VIDEO_MOBILE_APP_INSTALL"
    "LINE_ITEM_TYPE_DISPLAY_MOBILE_APP_INVENTORY"
    "LINE_ITEM_TYPE_VIDEO_MOBILE_APP_INVENTORY"
    "LINE_ITEM_TYPE_AUDIO_DEFAULT"
    "LINE_ITEM_TYPE_VIDEO_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_ACTION"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_NON_SKIPPABLE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_VIDEO_SEQUENCE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_AUDIO"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_REACH"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_SIMPLE"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_NON_SKIPPABLE_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_REACH_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_SIMPLE_OVER_THE_TOP"
    "LINE_ITEM_TYPE_YOUTUBE_AND_PARTNERS_TARGET_FREQUENCY"})

(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})

(s/def ::reservation-type
  #{"RESERVATION_TYPE_UNSPECIFIED"
    "RESERVATION_TYPE_NOT_GUARANTEED"
    "RESERVATION_TYPE_PROGRAMMATIC_GUARANTEED"
    "RESERVATION_TYPE_TAG_GUARANTEED"
    "RESERVATION_TYPE_PETRA_VIRAL"
    "RESERVATION_TYPE_INSTANT_RESERVE"})

(s/def ::bid-strategy
  (spec/only-keys :opt-un [::bidding-strategy/fixed-bid
                           ::bidding-strategy/maximize-spend-auto-bid
                           ::bidding-strategy/performance-goal-auto-bid]))

(s/def ::budget
  (spec/only-keys :req-un [::line-item.budget/budget-allocation-type]
                  :opt-un [::line-item.budget/max-amount
                           ::line-item.budget/budget-unit]))
(s/def ::frequency-cap
  (spec/only-keys :opt-un [::frequency-cap/max-impressions
                           ::frequency-cap/max-views
                           ::frequency-cap/time-unit
                           ::frequency-cap/time-unit-count
                           ::frequency-cap/unlimited]))

(s/def ::mobile-app
  (spec/only-keys :req-un [::mobile-app/app-id]
                  :opt-un [::mobile-app/display-name
                           ::mobile-app/publisher
                           ::mobile-app/platform]))

(s/def ::pacing
  (spec/only-keys :req-un [::pacing/pacing-type
                           ::pacing/pacing-period]
                  :opt-un [::pacing/daily-max-impressions
                           ::pacing/daily-max-micros]))

(s/def ::partner-revenue-model
  (spec/only-keys :req-un [::partner-revenue-model/markup-type
                           ::partner-revenue-model/markup-amount]))

(s/def ::flight
  (spec/only-keys :req-un [::line-item.flight/flight-date-type]
                  :opt-un [::line-item.flight/date-range]))

(s/def ::conversion-counting
  (spec/only-keys :opt-un [::conversion-counting-config/post-view-count-percentage-millis
                           ::conversion-counting-config/floodlight-activity-configs]))

(s/def ::integration-details
  (spec/only-keys :opt-un [::integration-details/integration-code
                           ::integration-details/details]))

(s/def ::costs
  (spec/only-keys :req-un [::partner-costs/cost-type
                           ::partner-costs/fee-type]
                  :opt-un [::partner-costs/fee-amount
                           ::partner-costs/fee-percentage-millis
                           ::partner-costs/invoice-type]))

(s/def ::partner-costs
  (s/coll-of ::costs :into []))

(s/def ::targeting-expansion
  (spec/only-keys :req-un [::targeting-expansion-config/targeting-expansion-level]
                  :opt-un [::targeting-expansion-config/exclude-first-party-audience]))

(s/def ::youtube-partner-settings
  (spec/only-keys :req-un [::youtube-and-partners-settings/bidding-strategy]
                  :opt-un [::youtube-and-partners-settings/content-category
                           ::youtube-and-partners-settings/frequency-cap
                           ::youtube-and-partners-settings/inventory-source-settings
                           ::youtube-and-partners-settings/lead-form-id
                           ::youtube-and-partners-settings/linked-merchant-id
                           ::youtube-and-partners-settings/related-video-ids
                           ::youtube-and-partners-settings/target-frequency
                           ::youtube-and-partners-settings/third-party-measurement-settings
                           ::youtube-and-partners-settings/video-ad-sequence-settings]))

(s/def ::spec
  (spec/only-keys :req-un [::bid-strategy
                           ::budget
                           ::display-name
                           ::entity-status
                           ::flight
                           ::frequency-cap
                           ::insertion-order-id
                           ::line-item-type
                           ::pacing
                           ::partner-revenue-model]
                  :opt-un [::advertiser/advertiser-id
                           ::campaign/campaign-id
                           ::conversion-counting
                           ::creative-ids
                           ::exclude-new-exchanges
                           ::integration-details
                           ::line-item-id
                           ::mobile-app
                           ::name
                           ::partner-costs
                           ::reservation-type
                           ::targeting-expansion
                           ::update-time
                           ::warning-messages
                           ::youtube-partner-settings]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::bid-strategy
                           ::budget
                           ::display-name
                           ::entity-status
                           ::flight
                           ::frequency-cap
                           ::insertion-order-id
                           ::line-item-type
                           ::pacing
                           ::partner-revenue-model
                           ::advertiser/advertiser-id
                           ::campaign/campaign-id
                           ::conversion-counting
                           ::creative-ids
                           ::exclude-new-exchanges
                           ::integration-details
                           ::line-item-id
                           ::mobile-app
                           ::name
                           ::partner-costs
                           ::reservation-type
                           ::targeting-expansion
                           ::update-time
                           ::warning-messages
                           ::youtube-partner-settings]))
