(ns com.adgoji.displayvideo-client.core
  (:import
   (com.google.api.client.auth.oauth2 Credential)
   (com.google.api.client.http HttpRequest HttpRequestInitializer)
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$Builder)))

(defn- set-http-timeout
  [^Credential credential ^long connect-timeout-ms ^long read-timeout-ms]
  (reify
    HttpRequestInitializer
    (^void initialize [_this ^HttpRequest http-request]
      (.initialize credential http-request)
      (.setConnectTimeout http-request connect-timeout-ms)
      (.setReadTimeout http-request read-timeout-ms))))

(defn new
  ^DisplayVideo
  [^Credential credential ^String application-name
   {:keys [connect-timeout-ms read-timeout-ms]
    :or   {connect-timeout-ms 60000
           read-timeout-ms    60000}}]
  (-> (DisplayVideo$Builder. (. credential getTransport)
                             (. credential getJsonFactory)
                             (set-http-timeout credential
                                               connect-timeout-ms
                                               read-timeout-ms))
      (.setApplicationName application-name)
      (.build)))
