(ns com.adgoji.displayvideo-spec.displayvideo.bulk-edit-assigned-targeting-options-response
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.line-item :as line-item]
   [com.adgoji.displayvideo-spec.displayvideo.status :as status]
   [com.adgoji.spec.interface :as spec]))

(s/def ::updated-line-item-ids
  (s/coll-of ::line-item/line-item-id
             :distinct true
             :into []))

(s/def ::failed-line-item-ids
  (s/coll-of ::line-item/line-item-id
             :distinct true
             :into []))

(s/def ::errors
  (s/coll-of ::status/spec :into []))

(s/def ::spec
  (spec/only-keys :opt-un [::updated-line-item-ids
                           ::failed-line-item-ids
                           ::errors]))
