(ns com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-settings
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-bidding-strategy :as youtube-and-partners-bidding-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-third-party-measurement-settings :as youtube-and-partners-third-party-measurement-settings]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-and-partners-inventory-source-config :as youtube-and-partners-inventory-source-config]
   [com.adgoji.displayvideo-spec.displayvideo.target-frequency :as target-frequency]
   [com.adgoji.displayvideo-spec.displayvideo.video-ad-sequence-settings :as video-ad-sequence-settings]))

(s/def ::bidding-strategy
  (spec/only-keys
   :opt-un [::youtube-and-partners-bidding-strategy/type
            ::youtube-and-partners-bidding-strategy/ad-group-effective-target-cpa-value
            ::youtube-and-partners-bidding-strategy/ad-group-effective-target-cpa-source
            ::youtube-and-partners-bidding-strategy/value]))

(s/def ::view-frequency-cap
  (spec/only-keys
   :opt-un [::frequency-cap/max-impressions
            ::frequency-cap/max-views
            ::frequency-cap/time-unit
            ::frequency-cap/time-unit-count
            ::frequency-cap/unlimited]))

(s/def ::third-party-measurement-settings
  (spec/only-keys
   :opt-un [::youtube-and-partners-third-party-measurement-settings/brand-lift-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/brand-safety-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/reach-vendor-configs
            ::youtube-and-partners-third-party-measurement-settings/viewability-vendor-configs]))

(s/def ::inventory-source-settings
  (spec/only-keys
   :opt-un [::youtube-and-partners-inventory-source-config/include-youtube-search
            ::youtube-and-partners-inventory-source-config/include-youtube-videos
            ::youtube-and-partners-inventory-source-config/include-google-tv
            ::youtube-and-partners-inventory-source-config/include-youtube-video-partners]))

(s/def ::content-category
  #{"YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_UNSPECIFIED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_STANDARD"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_EXPANDED"
    "YOUTUBE_AND_PARTNERS_CONTENT_CATEGORY_LIMITED"})

(s/def ::effective-content-category ::content-category)

(s/def ::target-frequency
  (spec/only-keys :opt-un [::target-frequency/target-count
                           ::target-frequency/time-unit
                           ::target-frequency/time-unit-count]))

(s/def ::linked-merchant-id int?)

(s/def ::related-video-ids
  (s/coll-of int? :distinct true :into []))

(s/def ::lead-form-id int?)

(s/def ::video-ad-sequence-settings
  (spec/only-keys :opt-un [::video-ad-sequence-settings/minimum-duration
                           ::video-ad-sequence-settings/steps]))
