(ns com.adgoji.displayvideo-spec.displayvideo.bidding-strategy
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.maximize-spend-bid-strategy :as maximize-spend-bid-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.fixed-bid-strategy :as fixed-bid-strategy]
   [com.adgoji.displayvideo-spec.displayvideo.performance-goal-bid-strategy :as performance-goal-bid-strategy]))

(s/def ::maximize-spend-auto-bid
  (spec/only-keys :req-un [::maximize-spend-bid-strategy/performance-goal-type]
                  :opt-un [::maximize-spend-bid-strategy/custom-bidding-algotithm-id
                           ::maximize-spend-bid-strategy/max-average-cpm-bid-amount-micros
                           ::maximize-spend-bid-strategy/raise-bid-for-deals]))

(s/def ::fixed-bid
  (spec/only-keys :opt-un [::fixed-bid-strategy/bid-amount-micros]))

(s/def ::performance-goal-auto-bid
  (spec/only-keys :req-un [::performance-goal-bid-strategy/performance-goal-amount-micros
                           ::performance-goal-bid-strategy/performance-goal-type]
                  :opt-un [::performance-goal-bid-strategy/custom-bidding-algotithm-id
                           ::performance-goal-bid-strategy/max-average-cpm-bid-amount-micros]))
