(ns com.adgoji.displayvideo-spec.displayvideo.site
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]))

(s/def ::name string?)
(s/def ::url-or-app-id string?)
(s/def ::deleted-sites (s/coll-of string?))
(s/def ::site
  (spec/only-keys :req-un [::url-or-app-id]
                  :opt-un [::name]))

(s/def ::created-sites
  (s/coll-of ::site :distinct true :into []))

(s/def ::new-sites
  (s/coll-of ::site :distinct true :into []))
