(ns com.adgoji.displayvideo-api.partners.channels
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.partner-channels.interface :as channels]))

(defn create
  "Create a new channel"
  [client partner-id channel]
  (channels/create client partner-id channel))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel ::displayvideo-spec/channel)
  :ret ::displayvideo-spec/channel)

(defn update-by-id
  "Update an existing channel by `partner-id` and `channel-id`.
  
    Request body is the same as for [[create]] function. Additionally
    `update-mask` is a mandatory parameter, it should be a sequence of
    fully qualified names of fields (as keywords)."
  [client partner-id channel-id channel update-mask]
  (channels/update-by-id client
                         partner-id
                         channel-id
                         channel
                         update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id
               :channel ::displayvideo-spec/channel
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/channel)

(defn get-list
  "Returns a list of all partner's channels."
  [client partner-id opts]
  (channels/get-list client partner-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/channels)

(defn get-by-id
  "Get a single channel by `partner-id` and `channel-id`."
  [client partner-id channel-id]
  (channels/get-by-id client partner-id channel-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :partner-id ::displayvideo-spec/partner-id
               :channel-id ::displayvideo-spec/channel-id)
  :ret ::displayvideo-spec/channel)