(ns com.adgoji.displayvideo-spec.displayvideo.insertion-order
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.partner-costs :as partner-costs]
   [com.adgoji.displayvideo-spec.displayvideo.pacing :as pacing]
   [com.adgoji.displayvideo-spec.displayvideo.frequency-cap :as frequency-cap]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.performance-goal :as performance-goal]
   [com.adgoji.displayvideo-spec.displayvideo.insertion-order.budget :as insertion-order.budget]
   [com.adgoji.displayvideo-spec.displayvideo.bidding-strategy :as bidding-strategy]))

(s/def ::name string?)
(s/def ::insertion-order-id pos-int?)
(s/def ::display-name string?)
(s/def ::insertion-order-type
  #{"INSERTION_ORDER_TYPE_UNSPECIFIED"
    "RTB"
    "OVER_THE_TOP"})
(s/def ::entity-status
  #{"ENTITY_STATUS_UNSPECIFIED"
    "ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_ARCHIVED"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_DRAFT"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)

(s/def ::partner-cost
  (spec/only-keys :req-un [::partner-costs/cost-type
                           ::partner-costs/fee-type
                           ::partner-costs/invoice-type]
                  :opt-un [::partner-costs/fee-amount
                           ::partner-costs/fee-percentage-millis]))

(s/def ::partner-costs
  (s/coll-of ::partner-cost :into []))

(s/def ::pacing
  (spec/only-keys :req-un [::pacing/pacing-period
                           ::pacing/pacing-type]
                  :opt-un [::pacing/daily-max-micros
                           ::pacing/daily-max-impressions]))

(s/def ::frequency-cap ::frequency-cap/spec)

(s/def ::integration-details
  (spec/only-keys :opt-un [::integration-details/integration-code
                           ::integration-details/details]))

(s/def ::performance-goal
  (spec/only-keys :req-un [::performance-goal/performance-goal-type]
                  :opt-un [::performance-goal/performance-goal-amount-micros
                           ::performance-goal/performance-goal-percentage-micros
                           ::performance-goal/performance-goal-string]))

(s/def ::budget
  (spec/only-keys :req-un [::insertion-order.budget/budget-unit
                           ::insertion-order.budget/budget-segments]
                  :opt-un [::insertion-order.budget/automation-type]))

(s/def ::bid-strategy
  (spec/only-keys :opt-un [::bidding-strategy/maximize-spend-auto-bid
                           ::bidding-strategy/fixed-bid
                           ::bidding-strategy/performance-goal-auto-bid]))

(s/def ::reservation-type
  #{"RESERVATION_TYPE_UNSPECIFIED"
    "RESERVATION_TYPE_NOT_GUARANTEED"
    "RESERVATION_TYPE_PROGRAMMATIC_GUARANTEED"
    "RESERVATION_TYPE_TAG_GUARANTEED"
    "RESERVATION_TYPE_PETRA_VIRAL"
    "RESERVATION_TYPE_INSTANT_RESERVE"})

(s/def ::billable-outcome
  #{"BILLABLE_OUTCOME_UNSPECIFIED"
    "BILLABLE_OUTCOME_PAY_PER_IMPRESSION"})
