(ns com.adgoji.advertisers-location-lists.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$Advertisers$LocationLists$List)
   (com.google.api.services.displayvideo.v2.model LocationList)))

(defn create
  [^DisplayVideo client advertiser-id location-list]
  (let [location-list-conformed
        (spec/check location-list ::displayvideo-spec/location-list)

        location-list-request
        (java-utils/clj->java LocationList location-list-conformed)]
    (-> client
        (.advertisers)
        (.locationLists)
        (.create (long advertiser-id) location-list-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/location-list))))

(defn- fetch-location-lists-page
  [^DisplayVideo$Advertisers$LocationLists$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client advertiser-id {:keys [order-by filter-expr limit]}]
  (let [request (-> client
                    (.advertisers)
                    (.locationLists)
                    (.list (long advertiser-id)))]
    (when order-by
      (.setOrderBy ^DisplayVideo$Advertisers$LocationLists$List request order-by))
    (when filter-expr
      (.setFilter ^DisplayVideo$Advertisers$LocationLists$List request filter-expr))
    (-> (sdk-client-utils/execute-and-convert-paginated (partial fetch-location-lists-page request)
                                                        :location-lists
                                                        limit)
        (spec/check ::displayvideo-spec/location-lists))))

(defn get-by-id
  [^DisplayVideo client advertiser-id location-list-id]
  (-> client
      (.advertisers)
      (.locationLists)
      (.get (long advertiser-id) (long location-list-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::displayvideo-spec/location-list)))

(defn update-by-id
  [^DisplayVideo client
   advertiser-id
   location-list-id
   location-list
   update-mask]
  (let [mask                  (-> update-mask
                                  (spec/check ::displayvideo-spec/update-mask)
                                  sdk-client-utils/normalize-mask)
        location-list-request (java-utils/clj->java LocationList location-list)]
    (-> client
        (.advertisers)
        (.locationLists)
        (.patch (long advertiser-id)
                (long location-list-id)
                location-list-request)
        (.setUpdateMask mask)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::displayvideo-spec/location-list))))
