(ns com.adgoji.cm-spec.cm.report
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.cm-spec.cm.report.criteria :as report.criteria]
   [com.adgoji.cm-spec.cm.report.schedule :as report.schedule]
   [com.adgoji.cm-spec.cm.report.reach-criteria :as report.reach-criteria]
   [com.adgoji.cm-spec.cm.report.path-to-conversion-criteria :as report.path-to-conversion-criteria]
   [com.adgoji.cm-spec.cm.report.cross-dimension-reach-criteria :as report.cross-dimension-reach-criteria]
   [com.adgoji.cm-spec.cm.report.floodlight-criteria :as report.floodlight-criteria]
   [com.adgoji.cm-spec.cm.report.delivery :as report.delivery]))

(s/def ::id spec/strict-long?)
(s/def ::owner-profile-id spec/strict-long?)
(s/def ::account-id spec/strict-long?)
(s/def ::sub-account-id spec/strict-long?)
(s/def ::name string?)
(s/def ::file-name string?)
(s/def ::kind string?)
(s/def ::type
  #{"STANDARD"
    "REACH"
    "PATH_TO_CONVERSION"
    "CROSS_DIMENSION_REACH"
    "FLOODLIGHT"})
(s/def ::etag string?)
(s/def ::last-modified-time integer?)
(s/def ::format #{"CSV" "EXCEL"})
(s/def ::criteria ::report.criteria/spec)
(s/def ::schedule ::report.schedule/spec)
(s/def ::reach-criteria ::report.reach-criteria/spec)
(s/def ::path-to-conversion-criteria ::report.path-to-conversion-criteria/spec)
(s/def ::cross-dimension-reach-criteria ::report.cross-dimension-reach-criteria/spec)
(s/def ::floodlight-criteria ::report.floodlight-criteria/spec)
(s/def ::delivery ::report.delivery/spec)
(s/def ::spec
  (s/keys :req-un [::name
                   ::type]
          :opt-un [::id
                   ::owner-profile-id
                   ::account-id
                   ::sub-account-id
                   ::file-name
                   ::kind
                   ::etag
                   ::last-modified-time
                   ::format
                   ::criteria
                   ::schedule
                   ::reach-criteria
                   ::path-to-conversion-criteria
                   ::cross-dimension-reach-criteria
                   ::floodlight-criteria
                   ::delivery]))
(s/def ::spec-update
  (s/keys :opt-un [::id
                   ::name
                   ::type
                   ::owner-profile-id
                   ::account-id
                   ::sub-account-id
                   ::file-name
                   ::kind
                   ::etag
                   ::last-modified-time
                   ::format
                   ::criteria
                   ::schedule
                   ::reach-criteria
                   ::path-to-conversion-criteria
                   ::cross-dimension-reach-criteria
                   ::floodlight-criteria
                   ::delivery]))
