(ns com.adgoji.cm-floodlight-activity-groups.core
  (:require
   [com.adgoji.cm-spec.interface :as cm-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.dfareporting Dfareporting Dfareporting$FloodlightActivityGroups$List)
   (com.google.api.services.dfareporting.model FloodlightActivityGroup)))

(defn- fetch-page
  [^Dfareporting$FloodlightActivityGroups$List request
   ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  "Returns a list of available floodlight activity groups by `profile-id`."
  [^Dfareporting client
   profile-id
   {:keys [ids
           floodlight-activity-group-type
           advertiser-id
           floodlight-configuration-id
           max-results
           search-string
           sort-field
           sort-order]}]
  (let [profile-id-conformed (spec/check profile-id ::cm-spec/profile-id)
        request              (-> client
                                 (.floodlightActivityGroups)
                                 (.list profile-id-conformed))]
    (when (seq ids)
      (.setIds ^Dfareporting$FloodlightActivityGroups$List request
               (spec/check ids ::cm-spec/ids)))
    (when floodlight-activity-group-type
      (.setType ^Dfareporting$FloodlightActivityGroups$List request
                (spec/check floodlight-activity-group-type
                            ::cm-spec/floodlight-activity-group-type)))
    (when advertiser-id
      (.setAdvertiserId ^Dfareporting$FloodlightActivityGroups$List request
                        (spec/check advertiser-id ::cm-spec/advertiser-id)))
    (when floodlight-configuration-id
      (.setFloodlightConfigurationId ^Dfareporting$FloodlightActivityGroups$List request
                                     (spec/check floodlight-configuration-id ::cm-spec/floodlight-configuration-id)))
    (when max-results
      (.setMaxResults ^Dfareporting$FloodlightActivityGroups$List request
                      (spec/check max-results ::cm-spec/max-results)))
    (when search-string
      (.setSearchString ^Dfareporting$FloodlightActivityGroups$List request
                        (spec/check search-string ::cm-spec/search-string)))
    (when sort-field
      (.setSortField ^Dfareporting$FloodlightActivityGroups$List request
                     (spec/check sort-field ::cm-spec/sort-field)))
    (when sort-order
      (.setSortOrder ^Dfareporting$FloodlightActivityGroups$List request
                     (spec/check sort-order ::cm-spec/sort-order)))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-page request)
         :floodlight-activity-groups
         max-results)
        (spec/check ::cm-spec/floodlight-activity-groups))))

(defn get-by-id
  [^Dfareporting client profile-id group-id]
  (-> client
      (.floodlightActivityGroups)
      (.get (spec/check profile-id ::cm-spec/profile-id)
            (spec/check group-id ::cm-spec/floodlight-activity-group-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::cm-spec/floodlight-activity-group)))

(defn insert
  [^Dfareporting client profile-id floodlight-activity-group]
  (let [group-conformed (spec/check floodlight-activity-group
                                    ::cm-spec/floodlight-activity-group)
        group-request   (java-utils/clj->java FloodlightActivityGroup
                                              group-conformed)]
    (-> client
        (.floodlightActivityGroups)
        (.insert (spec/check profile-id ::cm-spec/profile-id)
                 group-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity-group))))

(defn patch
  [^Dfareporting client profile-id floodlight-activity-group-id content]
  (let [content-conformed (spec/check content
                                      ::cm-spec/floodlight-activity-group-update)
        content-request   (java-utils/clj->java FloodlightActivityGroup
                                                content-conformed)]
    (-> client
        (.floodlightActivityGroups)
        (.patch (spec/check profile-id ::cm-spec/profile-id)
                (spec/check floodlight-activity-group-id
                            ::cm-spec/floodlight-activity-group-id)
                content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity-group))))

(defn put
  [^Dfareporting client profile-id floodlight-activity-group]
  (let [content-conformed (spec/check floodlight-activity-group
                                      ::cm-spec/floodlight-activity-group)
        content-request   (java-utils/clj->java FloodlightActivityGroup
                                                content-conformed)]
    (-> client
        (.floodlightActivityGroups)
        (.update (spec/check profile-id ::cm-spec/profile-id)
                 content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity-group))))
