(ns com.adgoji.cm-floodlight-activities.interface
  (:require
   [com.adgoji.cm-floodlight-activities.core
    :as
    cm-floodlight-activities.core]))

(defn get-list
  [client profile-id opts]
  (cm-floodlight-activities.core/get-list client profile-id opts))

(defn get-by-id
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities.core/get-by-id client
                                           profile-id
                                           floodlight-activity-id))

(defn insert
  [client profile-id floodlight-activity]
  (cm-floodlight-activities.core/insert client
                                        profile-id
                                        floodlight-activity))

(defn patch
  [client profile-id floodlight-activity-id content]
  (cm-floodlight-activities.core/patch client
                                       profile-id
                                       floodlight-activity-id
                                       content))

(defn put
  [client profile-id floodlight-activity]
  (cm-floodlight-activities.core/put client profile-id floodlight-activity))

(defn delete
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities.core/delete client
                                        profile-id
                                        floodlight-activity-id))

(defn generate-tag
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities.core/generate-tag client
                                              profile-id
                                              floodlight-activity-id))
