(ns com.adgoji.cm-api.advertisers
  (:require
   [com.adgoji.cm-advertisers.interface :as cm-advertisers]
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.interface :as cm-spec]))

(defn get-list
  "Returns a list of advertisers by `profile-id`.

  The result can be altered using various `opts`, which are described
  in the official
  documentation: [[https://developers.google.com/doubleclick-advertisers/rest/v4/advertisers/list#query-parameters]].

  Options should be provided as a map with kebab-case keys."
  [client profile-id opts]
  (cm-advertisers/get-list client profile-id opts))

(s/fdef get-list
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :opts (s/keys :opt-un [::cm-spec/max-results
                                      ::cm-spec/subaccount-id
                                      ::cm-spec/status
                                      ::cm-spec/advertiser-group-ids
                                      ::cm-spec/floodlight-configuration-ids
                                      ::cm-spec/include-advertisers-without-groups-only
                                      ::cm-spec/only-parent
                                      ::cm-spec/ids
                                      ::cm-spec/search-string
                                      ::cm-spec/search-string
                                      ::cm-spec/sort-field
                                      ::cm-spec/sort-order]))
  :ret ::cm-spec/advertisers)

(defn get-by-id
  "Returns a single advertiser by provided `profile-id` and
  `advertiser-id`."
  [client profile-id advertiser-id]
  (cm-advertisers/get-by-id client profile-id advertiser-id))

(s/fdef get-by-id
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :advertiser-id ::cm-spec/advertiser-id)
  :ret ::cm-spec/advertiser)

(defn insert
  "Create a new advertiser."
  [client profile-id advertiser]
  (cm-advertisers/insert client profile-id advertiser))

(s/fdef insert
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :advertiser ::cm-spec/advertiser)
  :ret ::cm-spec/advertiser)

(defn patch
  "Updates an existing advertiser.

  This method supports patch semantics."
  [client profile-id advertiser-id content]
  (cm-advertisers/patch client profile-id advertiser-id content))

(s/fdef patch
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :advertiser-id ::cm-spec/advertiser-id
               :content ::cm-spec/advertiser-update)
  :ret ::cm-spec/advertiser)

(defn put
  "Updates an existing advertiser."
  [client profile-id advertiser]
  (cm-advertisers/put client profile-id advertiser))

(s/fdef put
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :advertiser ::cm-spec/advertiser)
  :ret ::cm-spec/advertiser)
