(ns com.adgoji.cm-spec.cm.report.schedule
  (:require
   [clojure.spec.alpha :as s]))

(s/def ::active boolean?)
(s/def ::repeats #{"DAILY" "WEEKLY" "MONTHLY"})
(s/def ::week-day
  #{"SUNDAY"
    "MONDAY"
    "TUESDAY"
    "WEDNESDAY"
    "THURSDAY"
    "FRIDAY"
    "SATURDAY"})
(s/def ::repeats-on-week-days
  (s/coll-of ::week-day :into [] :distinct true))
(s/def ::every integer?)
(s/def ::start-date string?)
(s/def ::expiration-date string?)
(s/def ::runs-on-day-of-month
  #{"DAY_OF_MONTH"
    "WEEK_OF_MONTH"})
(s/def ::timezone string?)
(s/def ::spec
  (s/keys :req-un [::active]
          :opt-un [::repeats
                   ::repeats-on-week-days
                   ::every
                   ::start-date
                   ::expiration-date
                   ::runs-on-day-of-month
                   ::timezone]))
