(ns com.adgoji.cm-reports-files.core
  (:require
   [clojure.string :as str]
   [com.adgoji.cm-spec.interface :as cm-spec]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.dfareporting Dfareporting Dfareporting$Reports$Files$List)))

(defn- fetch-files-page
  [^Dfareporting$Reports$Files$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)
      ;; For some reason this API returns `:next-page-token` as an
      ;; empty string.
      (update :next-page-token #(if (str/blank? %) nil %))))

(defn get-list
  [^Dfareporting client
   profile-id
   report-id
   {:keys [max-results sort-field sort-order]}]
  (let [request (-> client
                    (.reports)
                    (.files)
                    (.list (spec/check profile-id ::cm-spec/profile-id)
                           (spec/check report-id ::cm-spec/report-id)))]
    (when max-results
      (.setMaxResults ^Dfareporting$Reports$Files$List request
                      (spec/check max-results ::cm-spec/max-results)))
    (when sort-field
      (.setSortField ^Dfareporting$Reports$Files$List request
                     (spec/check sort-field ::cm-spec/sort-field)))
    (when sort-order
      (.setSortOrder ^Dfareporting$Reports$Files$List request
                     (spec/check sort-order ::cm-spec/sort-order)))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-files-page request)
         :items
         max-results)
        (spec/check ::cm-spec/files))))

(defn get-by-id
  [^Dfareporting client profile-id report-id file-id media?]
  (let [request (-> client
                    (.reports)
                    (.files)
                    (.get (spec/check profile-id ::cm-spec/profile-id)
                          (spec/check report-id ::cm-spec/report-id)
                          (spec/check file-id ::cm-spec/file-id)))]
    (if media?
      (.executeMediaAsInputStream request)
      (-> request
          (sdk-client-utils/execute-and-convert)
          (spec/check ::cm-spec/file)))))
