(ns com.adgoji.cm-api.floodlight-configurations
  (:require
   [com.adgoji.cm-floodlight-configurations.interface :as cm-floodlight-configurations]
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.interface :as cm-spec]))

(defn get-list
  "Returns a list of floodlight configurations by `profile-id`, possibly filtered.

  Vector of IDs of floodlight configurations to retrieve is a required
  field, otherwise an empty list will be returned."
  [client profile-id opts]
  (cm-floodlight-configurations/get-list client profile-id opts))

(s/fdef get-list
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :opts (s/keys :opt-un [::cm-spec/ids]))
  :ret ::cm-spec/floodlight-configurations)

(defn get-by-id
  "Returns a single floodlight configuration by provided `profile-id`
  and `configuration-id`."
  [client profile-id configuration-id]
  (cm-floodlight-configurations/get-by-id client profile-id configuration-id))

(s/fdef get-by-id
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :configuration-id ::cm-spec/floodlight-configuration-id)
  :ret ::cm-spec/floodlight-configuration)

(defn patch
  "Updates an existing floodlight configuration.

  This method supports patch semantics."
  [client profile-id configuration-id content]
  (cm-floodlight-configurations/patch client
                                      profile-id
                                      configuration-id
                                      content))

(s/fdef patch
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :configuration-id ::cm-spec/floodlight-configuration-id
               :content ::cm-spec/floodlight-configuration)
  :ret ::cm-spec/floodlight-configuration)

(defn put
  "Updates an existing floodlight configuration."
  [client profile-id configuration]
  (cm-floodlight-configurations/put client profile-id configuration))

(s/fdef put
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :configuration ::cm-spec/floodlight-configuration)
  :ret ::cm-spec/floodlight-configuration)
