(ns com.adgoji.cm-api.floodlight-activities
  (:require
   [com.adgoji.cm-floodlight-activities.interface
    :as
    cm-floodlight-activities]
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.interface :as cm-spec]))

(defn get-list
  "Returns a list of floodlight activities by `profile-id` and `otps`.

  Some of the `opts` are required to produce non-empty list as a
  result. All available options are described in the official
  documentation: [[https://developers.google.com/doubleclick-advertisers/rest/v4/floodlightActivities/list#query-parameters]].

  Options should be provided as a map with kebab-case keys."
  [client profile-id opts]
  (cm-floodlight-activities/get-list client profile-id opts))

(s/fdef get-list
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :opts (s/keys :opt-un [::cm-spec/ids
                                      ::cm-spec/floodlight-activity-group-ids
                                      ::cm-spec/floodlight-configuration-id
                                      ::cm-spec/advertiser-id
                                      ::cm-spec/floodlight-activity-tag-string
                                      ::cm-spec/floodlight-activity-group-type
                                      ::cm-spec/floodlight-activity-group-tag-string
                                      ::cm-spec/floodlight-activity-group-name
                                      ::cm-spec/max-results
                                      ::cm-spec/search-string
                                      ::cm-spec/sort-field
                                      ::cm-spec/sort-order]))
  :ret ::cm-spec/floodlight-activities)

(defn get-by-id
  "Return a single floodlight activity by `profile-id` and
  `floodlight-activity-id`."
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities/get-by-id client
                                      profile-id
                                      floodlight-activity-id))

(s/fdef get-by-id
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-id ::cm-spec/floodlight-activity-id)
  :ret ::cm-spec/floodlight-activity)

(defn insert
  "Create a new floodlight activity."
  [client profile-id floodlight-activity]
  (cm-floodlight-activities/insert client profile-id floodlight-activity))

(s/fdef insert
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity ::cm-spec/floodlight-activity)
  :ret ::cm-spec/floodlight-activity)

(defn patch
  "Update an existing floodlight activity.

  This method supports patch semantics."
  [client profile-id floodlight-activity-id content]
  (cm-floodlight-activities/patch client
                                  profile-id
                                  floodlight-activity-id
                                  content))

(s/fdef patch
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-id ::cm-spec/floodlight-activity-id
               :content ::cm-spec/floodlight-activity-update)
  :ret ::cm-spec/floodlight-activity)

(defn put
  "Updates an existing floodlight activity."
  [client profile-id floodlight-acvitity]
  (cm-floodlight-activities/put client profile-id floodlight-acvitity))

(s/fdef put
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity ::cm-spec/floodlight-activity)
  :ret ::cm-spec/floodlight-activity)

(defn delete
  "Deletes an existing floodlight activity."
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities/delete client profile-id floodlight-activity-id))

(s/fdef delete
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-id ::cm-spec/floodlight-activity-id)
  :ret (s/and map? empty?))

(defn generate-tag
  "Generates a tag for a floodlight activity."
  [client profile-id floodlight-activity-id]
  (cm-floodlight-activities/generate-tag client
                                         profile-id
                                         floodlight-activity-id))

(s/fdef generate-tag
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-id ::cm-spec/floodlight-activity-id)
  :ret ::cm-spec/floodlight-activities-generate-tag-response)
