(ns com.adgoji.cm-spec.cm.floodlight-configuration
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.cm-spec.cm.lookback-configuration :as lookback-configuration]
   [com.adgoji.cm-spec.cm.omniture-settings :as omniture-settings]
   [com.adgoji.cm-spec.cm.tag-settings :as tag-settings]
   [com.adgoji.cm-spec.cm.user-defined-variable-configuration :as user-defined-variable-configuration]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]
   [com.adgoji.cm-spec.cm.third-party-authentication-token :as third-party-authentication-token]
   [com.adgoji.cm-spec.cm.custom-viewability-metric :as custom-viewability-metric]))

(s/def ::id spec/strict-long?)
(s/def ::account-id spec/strict-long?)
(s/def ::subaccount-id spec/strict-long?)
(s/def ::advertiser-id spec/strict-long?)
(s/def ::first-day-of-week #{"SUNDAY" "MONDAY"})
(s/def ::lookback-configuration ::lookback-configuration/spec)
(s/def ::natural-search-conversion-attribution-option string?)
(s/def ::omniture-settings ::omniture-settings/spec)
(s/def ::exposure-to-conversion-enabled boolean?)
(s/def ::tag-settings ::tag-settings/spec)
(s/def ::kind string?)
(s/def ::user-defined-variable-configurations
  (s/coll-of ::user-defined-variable-configuration/spec
             :distinct true
             :into []))
(s/def ::analytics-data-sharing-enabled boolean?)
(s/def ::id-dimension-value ::dimension-value/spec)
(s/def ::advertiser-id-dimension-value ::dimension-value/spec)
(s/def ::in-app-attribution-tracking-enabled boolean?)
(s/def ::third-party-authentication-tokens
  (s/coll-of ::third-party-authentication-token/spec
             :distinct true
             :into []))
(s/def ::custom-viewability-metric ::custom-viewability-metric/spec)
(s/def ::spec
  (s/keys :opt-un [::id
                   ::account-id
                   ::subaccount-id
                   ::advertiser-id
                   ::first-day-of-week
                   ::lookback-configuration
                   ::natural-search-conversion-attribution-option
                   ::omniture-settings
                   ::exposure-to-conversion-enabled
                   ::tag-settings
                   ::kind
                   ::user-defined-variable-configuration
                   ::analytics-data-sharing-enabled
                   ::id-dimension-value
                   ::advertiser-id-dimension-value
                   ::in-app-attribution-tracking-enabled
                   ::third-party-authentication-tokens
                   ::custom-viewability-metric]))
