(ns com.adgoji.cm-spec.cm.advertiser
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]
   [com.adgoji.cm-spec.cm.measurement-partner-advertiser-link
    :as
    measurement-partner-advertiser-link]
   [com.adgoji.spec.interface :as spec]))

(s/def ::id spec/strict-long?)
(s/def ::name string?)
(s/def ::account-id spec/strict-long?)
(s/def ::subaccount-id spec/strict-long?)
(s/def ::floodlight-configuration-id spec/strict-long?)
(s/def ::advertiser-group-id spec/strict-long?)
(s/def ::status #{"APPROVED" "ON_HOLD"})
(s/def ::default-email string?)
(s/def ::click-through-url-suffix string?)
(s/def ::default-click-through-event-tag-id spec/strict-long?)
(s/def ::id-dimension-value ::dimension-value/spec)
(s/def ::floodlight-configuration-id-dimension-value ::dimension-value/spec)
(s/def ::original-floodlight-configuration-id spec/strict-long?)
(s/def ::kind string?)
(s/def ::suspended boolean?)
(s/def ::measurement-partner-link ::measurement-partner-advertiser-link/spec)

(s/def ::spec
  (s/keys :req-un [::name]
          :opt-un [::id
                   ::account-id
                   ::subaccount-id
                   ::floodlight-configuration-id
                   ::advertiser-group-id
                   ::status
                   ::default-email
                   ::click-through-url-suffix
                   ::default-click-through-event-tag-id
                   ::id-dimension-value
                   ::floodlight-configuration-id-dimension-value
                   ::original-floodlight-configuration-id
                   ::kind
                   ::suspended
                   ::measurement-partner-link]))

(s/def ::spec-update
  (s/keys :opt-un [::id
                   ::name
                   ::account-id
                   ::subaccount-id
                   ::floodlight-configuration-id
                   ::advertiser-group-id
                   ::status
                   ::default-email
                   ::click-through-url-suffix
                   ::default-click-through-event-tag-id
                   ::id-dimension-value
                   ::floodlight-configuration-id-dimension-value
                   ::original-floodlight-configuration-id
                   ::kind
                   ::suspended
                   ::measurement-partner-link]))
