(ns com.adgoji.cm-spec.cm.report.floodlight-criteria
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm.date-range :as date-range]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]
   [com.adgoji.cm-spec.cm.sorted-dimension :as sorted-dimension]
   [com.adgoji.cm-spec.cm.report.floodlight-criteria.report-properties :as report.floodlight-criteria.report-properties]))

(s/def ::date-range ::date-range/spec)
(s/def ::floodlight-config-id ::dimension-value/spec)
(s/def ::dimension-filters
  (s/coll-of ::dimension-value/spec :into [] :distinct true))
(s/def ::dimensions
  (s/coll-of ::sorted-dimension/spec :into [] :distinct true))
(s/def ::metric-names
  (s/coll-of string? :into [] :distinct true))
(s/def ::custom-rich-media-events
  (s/coll-of ::dimension-value/spec :into [] :distinct true))
(s/def ::report-properties ::report.floodlight-criteria.report-properties/spec)
(s/def ::spec
  (s/keys :opt-un [::date-range
                   ::floodlight-config-id
                   ::dimension-filters
                   ::dimensions
                   ::metric-names
                   ::custom-rich-media-events
                   ::report-properties]))
