(ns com.adgoji.cm-spec.cm.report.criteria
  (:require
   [com.adgoji.cm-spec.cm.date-range :as date-range]
   [com.adgoji.cm-spec.cm.sorted-dimension :as sorted-dimension]
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]
   [com.adgoji.cm-spec.cm.activities :as activities]
   [com.adgoji.cm-spec.cm.custom-rich-media-events :as custom-rich-media-events]))

(s/def ::date-range ::date-range/spec)
(s/def ::dimensions
  (s/coll-of ::sorted-dimension/spec :into [] :distinct true))
(s/def ::metric-names
  (s/coll-of string? :into [] :distinct true))
(s/def ::dimension-filters
  (s/coll-of ::dimension-value/spec :into [] :distinct true))
(s/def ::activities ::activities/spec)
(s/def ::custom-rich-media-events ::custom-rich-media-events/spec)
(s/def ::spec
  (s/keys :opt-un [::date-range
                   ::dimensions
                   ::metric-names
                   ::dimension-filters
                   ::activities
                   ::custom-rich-media-events]))
