(ns com.adgoji.cm-spec.cm.floodlight-activity
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.cm-spec.cm.floodlight-activity-dynamic-tag :as floodlight-activity-dynamic-tag]
   [com.adgoji.cm-spec.cm.floodlight-activity-publisher-dynamic-tag :as floodlight-activity-publisher-dynamic-tag]
   [com.adgoji.cm-spec.cm.floodlight-activity-group :as floodlight-activity-group]
   [com.adgoji.cm-spec.cm.advertiser :as advertiser]
   [com.adgoji.cm-spec.cm.floodlight-configuration :as floodlight-configuration]
   [com.adgoji.cm-spec.cm.dimension-value :as dimension-value]))

(s/def ::id spec/strict-long?)
(s/def ::name string?)
(s/def ::tag-string string?)
(s/def ::expected-url string?)
(s/def ::secure boolean?)
(s/def ::kind string?)
(s/def ::counting-method
  #{"STANDARD_COUNTING"
    "UNIQUE_COUNTING"
    "SESSION_COUNTING"
    "TRANSACTIONS_COUNTING"
    "ITEMS_SOLD_COUNTING"})
(s/def ::tag-format #{"HTML" "XHTML"})
(s/def ::cache-busting-type
  #{"JAVASCRIPT"
    "ACTIVE_SERVER_PAGE"
    "JSP"
    "PHP"
    "COLD_FUSION"})
(s/def ::user-defined-variable-types
  (s/coll-of string? :distinct true :into []))
(s/def ::notes string?)
(s/def ::default-tags
  (s/coll-of ::floodlight-activity-dynamic-tag/spec
             :distinct true
             :into []))
(s/def ::publisher-tags
  (s/coll-of ::floodlight-activity-publisher-dynamic-tag/spec
             :distinct true
             :into []))
(s/def ::floodlight-activity-group-id ::floodlight-activity-group/id)
(s/def ::floodlight-configuration-id ::floodlight-configuration/id)
(s/def ::advertiser-id ::advertiser/id)
(s/def ::subaccount-id spec/strict-long?)
(s/def ::account-id spec/strict-long?)
(s/def ::floodlight-activity-group-type ::floodlight-activity-group/type)
(s/def ::floodlight-activity-group-tag-string ::floodlight-activity-group/tag-string)
(s/def ::floodlight-activity-group-name ::floodlight-activity-group/name)
(s/def ::ssl-compliant boolean?)
(s/def ::advertiser-id-dimension-value ::dimension-value/spec)
(s/def ::floodlight-configuration-id-dimension-value ::dimension-value/spec)
(s/def ::id-dimension-value ::dimension-value/spec)
(s/def ::ssl-required boolean?)
(s/def ::floodlight-tag-type
  #{"IFRAME"
    "IMAGE"
    "GLOBAL_SITE_TAG"})
(s/def ::status
  #{"ACTIVE"
    "ARCHIVED_AND_DISABLED"
    "DISABLED_POLICY"})
(s/def ::attribution-enabled boolean?)
(s/def ::spec
  (s/keys :req-un [::name
                   ::counting-method
                   ::floodlight-activity-group-id
                   ::floodlight-tag-type]
          :opt-un [::id
                   ::tag-string
                   ::expected-url
                   ::secure
                   ::kind
                   ::tag-format
                   ::cache-busting-type
                   ::user-defined-variable-types
                   ::notes
                   ::default-tags
                   ::publisher-tags
                   ::floodlight-configuration-id
                   ::advertiser-id
                   ::subaccount-id
                   ::account-id
                   ::floodlight-activity-group-type
                   ::floodlight-activity-group-tag-string
                   ::floodlight-activity-group-name
                   ::ssl-compliant
                   ::advertiser-id-dimension-value
                   ::floodlight-configuration-id-dimension-value
                   ::id-dimension-value
                   ::ssl-required
                   ::status
                   ::attribution-enabled]))
(s/def ::spec-update
  (s/keys :opt-un [::name
                   ::counting-method
                   ::floodlight-activity-group-id
                   ::floodlight-tag-type
                   ::id
                   ::tag-string
                   ::expected-url
                   ::secure
                   ::kind
                   ::tag-format
                   ::cache-busting-type
                   ::user-defined-variable-types
                   ::notes
                   ::default-tags
                   ::publisher-tags
                   ::floodlight-configuration-id
                   ::advertiser-id
                   ::subaccount-id
                   ::account-id
                   ::floodlight-activity-group-type
                   ::floodlight-activity-group-tag-string
                   ::floodlight-activity-group-name
                   ::ssl-compliant
                   ::advertiser-id-dimension-value
                   ::floodlight-configuration-id-dimension-value
                   ::id-dimension-value
                   ::ssl-required
                   ::status
                   ::attribution-enabled]))
