(ns com.adgoji.cm-spec.cm.date-range
  (:require
   [clojure.spec.alpha :as s]
   [clojure.java.data :as j])
  (:import
   (com.google.api.client.util DateTime)))

(defmethod j/from-java-deep DateTime
  [^DateTime instance _]
  instance)

(defmulti conform-date type :default ::default)

(defmethod conform-date String
  [^String date-str]
  (try
    (DateTime. date-str)
    (catch Exception _ ::s/invalid)))

(defmethod conform-date DateTime
  [^DateTime date-time]
  (.toStringRfc3339 date-time))

(def google-date?
  (s/conformer conform-date))

(s/def ::start-date google-date?)
(s/def ::end-date google-date?)
(s/def ::relative-date-range
  #{"TODAY"
    "YESTERDAY"
    "WEEK_TO_DATE"
    "MONTH_TO_DATE"
    "QUARTER_TO_DATE"
    "YEAR_TO_DATE"
    "PREVIOUS_WEEK"
    "PREVIOUS_MONTH"
    "PREVIOUS_QUARTER"
    "PREVIOUS_YEAR"
    "LAST_7_DAYS"
    "LAST_30_DAYS"
    "LAST_90_DAYS"
    "LAST_365_DAYS"
    "LAST_24_MONTHS"
    "LAST_14_DAYS"
    "LAST_60_DAYS"})
(s/def ::kind string?)
(s/def ::spec
  (s/keys :opt-un [::start-date
                   ::end-date
                   ::relative-date-range
                   ::kind]))
