(ns com.adgoji.cm-floodlight-activities.core
  (:require
   [com.adgoji.cm-spec.interface :as cm-spec]
   [com.adgoji.java-utils.interface :as java-utils]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.dfareporting Dfareporting Dfareporting$FloodlightActivities$List)
   (com.google.api.services.dfareporting.model FloodlightActivity)))

(defn- fetch-page
  [^Dfareporting$FloodlightActivities$List request
   ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^Dfareporting client
   profile-id
   {:keys [ids
           floodlight-activity-group-ids
           floodlight-configuration-id
           advertiser-id
           floodlight-activity-tag-string
           floodlight-activity-group-type
           floodlight-activity-group-tag-string
           floodlight-activity-group-name
           max-results
           search-string
           sort-field
           sort-order]}]
  (let [profile-id-conformed (spec/check profile-id ::cm-spec/profile-id)
        request              (-> client
                                 (.floodlightActivities)
                                 (.list profile-id-conformed))]
    (when (seq ids)
      (.setIds ^Dfareporting$FloodlightActivities$List request
               (spec/check ids ::cm-spec/ids)))
    (when (seq floodlight-activity-group-ids)
      (.setFloodlightActivityGroupIds ^Dfareporting$FloodlightActivities$List request
                                      (spec/check floodlight-activity-group-ids
                                                  ::cm-spec/floodlight-activity-group-ids)))
    (when floodlight-configuration-id
      (.setFloodlightConfigurationId ^Dfareporting$FloodlightActivities$List request
                                     (spec/check floodlight-configuration-id
                                                 ::cm-spec/floodlight-configuration-id)))
    (when advertiser-id
      (.setAdvertiserId ^Dfareporting$FloodlightActivities$List request
                        (spec/check advertiser-id ::cm-spec/advertiser-id)))
    (when floodlight-activity-tag-string
      (.setTagString ^Dfareporting$FloodlightActivities$List request
                     (spec/check floodlight-activity-tag-string ::cm-spec/floodlight-activity-tag-string)))
    (when floodlight-activity-group-type
      (.setFloodlightActivityGroupType ^Dfareporting$FloodlightActivities$List request
                                       (spec/check floodlight-activity-group-type
                                                   ::cm-spec/floodlight-activity-group-type)))
    (when floodlight-activity-group-tag-string
      (.setFloodlightActivityGroupTagString ^Dfareporting$FloodlightActivities$List request
                                            (spec/check floodlight-activity-group-tag-string
                                                        ::cm-spec/floodlight-activity-group-tag-string)))
    (when floodlight-activity-group-name
      (.setFloodlightActivityGroupName ^Dfareporting$FloodlightActivities$List request
                                       (spec/check floodlight-activity-group-name
                                                   ::cm-spec/floodlight-activity-group-name)))
    (when max-results
      (.setMaxResults ^Dfareporting$FloodlightActivities$List request
                      (spec/check max-results ::cm-spec/max-results)))
    (when search-string
      (.setSearchString ^Dfareporting$FloodlightActivities$List request
                        (spec/check search-string ::cm-spec/search-string)))
    (when sort-field
      (.setSortField ^Dfareporting$FloodlightActivities$List request
                     (spec/check sort-field ::cm-spec/sort-field)))
    (when sort-order
      (.setSortOrder ^Dfareporting$FloodlightActivities$List request
                     (spec/check sort-order ::cm-spec/sort-order)))
    (-> (sdk-client-utils/execute-and-convert-paginated
         (partial fetch-page request)
         :floodlight-activities
         max-results)
        (spec/check ::cm-spec/floodlight-activities))))

(defn get-by-id
  [^Dfareporting client profile-id floodlight-activity-id]
  (-> client
      (.floodlightActivities)
      (.get (spec/check profile-id ::cm-spec/profile-id)
            (spec/check floodlight-activity-id ::cm-spec/floodlight-activity-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::cm-spec/floodlight-activity)))

(defn insert
  [^Dfareporting client profile-id floodlight-activity]
  (let [activity-conformed (spec/check floodlight-activity
                                       ::cm-spec/floodlight-activity)
        activity-request   (java-utils/clj->java FloodlightActivity
                                                 activity-conformed)]
    (-> client
        (.floodlightActivities)
        (.insert (spec/check profile-id ::cm-spec/profile-id)
                 activity-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity))))

(defn patch
  [^Dfareporting client profile-id floodlight-activity-id content]
  (let [content-conformed (spec/check content
                                      ::cm-spec/floodlight-activity-update)
        content-request   (java-utils/clj->java FloodlightActivity
                                                content-conformed)]
    (-> client
        (.floodlightActivities)
        (.patch (spec/check profile-id ::cm-spec/profile-id)
                (spec/check floodlight-activity-id ::cm-spec/floodlight-activity-id)
                content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity))))

(defn put
  [^Dfareporting client profile-id floodlight-activity]
  (let [content-conformed (spec/check floodlight-activity
                                      ::cm-spec/floodlight-activity)
        content-request   (java-utils/clj->java FloodlightActivity
                                                content-conformed)]
    (-> client
        (.floodlightActivities)
        (.update (spec/check profile-id ::cm-spec/profile-id)
                 content-request)
        (sdk-client-utils/execute-and-convert)
        (spec/check ::cm-spec/floodlight-activity))))

(defn delete
  [^Dfareporting client profile-id floodlight-activity-id]
  (-> client
      (.floodlightActivities)
      (.delete (spec/check profile-id ::cm-spec/profile-id)
               (spec/check floodlight-activity-id ::cm-spec/floodlight-activity-id))
      (sdk-client-utils/execute-and-convert)))

(defn generate-tag
  [^Dfareporting client profile-id floodlight-activity-id]
  (-> client
      (.floodlightActivities)
      (.generatetag (spec/check profile-id ::cm-spec/profile-id))
      (.setFloodlightActivityId (spec/check floodlight-activity-id
                                            ::cm-spec/floodlight-activity-id))
      (sdk-client-utils/execute-and-convert)
      (spec/check ::cm-spec/floodlight-activities-generate-tag-response)))
