(ns com.adgoji.cm-api.floodlight-activity-groups
  (:require
   [com.adgoji.cm-floodlight-activity-groups.interface
    :as
    cm-floodlight-activity-groups]
   [clojure.spec.alpha :as s]
   [com.adgoji.cm-spec.interface :as cm-spec]))

(defn get-list
  "Returns a list of floodlight activity groups by provided
  `profile-id`.

  The result can be altered using various `opts`, which are described
  in the official
  documentation: [[https://developers.google.com/doubleclick-advertisers/rest/v4/floodlightActivityGroups/list#query-parameters]].

  Options should be provided as a map with kebab-case keys."
  [client profile-id opts]
  (cm-floodlight-activity-groups/get-list client profile-id opts))

(s/fdef get-list
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :opts (s/keys :opt-un [::cm-spec/ids
                                      ::cm-spec/floodlight-activity-group-type
                                      ::cm-spec/advertiser-id
                                      ::cm-spec/floodlight-configuration-id
                                      ::cm-spec/max-results
                                      ::cm-spec/search-string
                                      ::cm-spec/sort-field
                                      ::cm-spec/sort-order]))
  :ret ::cm-spec/floodlight-activity-groups)

(defn get-by-id
  "Returns a single floodlight activity group by provided `profile-id`
  and `floodlight-activity-group-id`."
  [client profile-id floodlight-activity-group-id]
  (cm-floodlight-activity-groups/get-by-id client
                                           profile-id
                                           floodlight-activity-group-id))

(s/fdef get-by-id
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-group-id ::cm-spec/floodlight-activity-group-id)
  :ret ::cm-spec/floodlight-activity-group)

(defn insert
  "Create a new floodlight activity group."
  [client profile-id floodlight-activity-group]
  (cm-floodlight-activity-groups/insert client
                                        profile-id
                                        floodlight-activity-group))

(s/fdef insert
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-group ::cm-spec/floodlight-activity-group)
  :ret ::cm-spec/floodlight-activity-group)

(defn patch
  "Updates an existing floodlight activity group.

  This method supports patch semantics."
  [client profile-id floodlight-activity-group-id content]
  (cm-floodlight-activity-groups/patch client
                                       profile-id
                                       floodlight-activity-group-id
                                       content))

(s/fdef patch
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-group-id ::cm-spec/floodlight-activity-group-id
               :content ::cm-spec/floodlight-activity-group-update)
  :ret ::cm-spec/floodlight-activity-group)

(defn put
  "Updates an existing floodlight activity group."
  [client profile-id floodlight-activity-group]
  (cm-floodlight-activity-groups/put client
                                     profile-id
                                     floodlight-activity-group))

(s/fdef put
  :args (s/cat :client ::cm-spec/client
               :profile-id ::cm-spec/profile-id
               :floodlight-activity-group ::cm-spec/floodlight-activity-group)
  :ret ::cm-spec/floodlight-activity-group)
